<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1VeterinaryGroupUserInvitationsPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string[]|null
     */
    protected $departments;

    /**
     * @var int
     */
    protected $emailTemplateNumber;

    /**
     * @var \DateTime|null
     */
    protected $expirationDate;

    /**
     * @var \DateTime
     */
    protected $entryDate;

    /**
     * @var \DateTime|null
     */
    protected $exitDate;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryGroupUserInvitationsPostBodyInvitedUser
     */
    protected $invitedUser;

    /**
     * @var string
     */
    protected $jobTitle;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryGroupUserInvitationsPostBodyVeterinaryGroup
     */
    protected $veterinaryGroup;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return string[]|null
     */
    public function getDepartments(): ?array
    {
        return $this->departments;
    }

    /**
     * @param string[]|null $departments
     */
    public function setDepartments(?array $departments): self
    {
        $this->initialized['departments'] = true;
        $this->departments = $departments;

        return $this;
    }

    public function getEmailTemplateNumber(): int
    {
        return $this->emailTemplateNumber;
    }

    public function setEmailTemplateNumber(int $emailTemplateNumber): self
    {
        $this->initialized['emailTemplateNumber'] = true;
        $this->emailTemplateNumber = $emailTemplateNumber;

        return $this;
    }

    public function getExpirationDate(): ?\DateTime
    {
        return $this->expirationDate;
    }

    public function setExpirationDate(?\DateTime $expirationDate): self
    {
        $this->initialized['expirationDate'] = true;
        $this->expirationDate = $expirationDate;

        return $this;
    }

    public function getEntryDate(): \DateTime
    {
        return $this->entryDate;
    }

    public function setEntryDate(\DateTime $entryDate): self
    {
        $this->initialized['entryDate'] = true;
        $this->entryDate = $entryDate;

        return $this;
    }

    public function getExitDate(): ?\DateTime
    {
        return $this->exitDate;
    }

    public function setExitDate(?\DateTime $exitDate): self
    {
        $this->initialized['exitDate'] = true;
        $this->exitDate = $exitDate;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getInvitedUser(): V1VeterinaryGroupUserInvitationsPostBodyInvitedUser
    {
        return $this->invitedUser;
    }

    /**
     * Id - Common Request Model.
     */
    public function setInvitedUser(V1VeterinaryGroupUserInvitationsPostBodyInvitedUser $invitedUser): self
    {
        $this->initialized['invitedUser'] = true;
        $this->invitedUser = $invitedUser;

        return $this;
    }

    public function getJobTitle(): string
    {
        return $this->jobTitle;
    }

    public function setJobTitle(string $jobTitle): self
    {
        $this->initialized['jobTitle'] = true;
        $this->jobTitle = $jobTitle;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryGroup(): V1VeterinaryGroupUserInvitationsPostBodyVeterinaryGroup
    {
        return $this->veterinaryGroup;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryGroup(V1VeterinaryGroupUserInvitationsPostBodyVeterinaryGroup $veterinaryGroup): self
    {
        $this->initialized['veterinaryGroup'] = true;
        $this->veterinaryGroup = $veterinaryGroup;

        return $this;
    }
}
