<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1VeterinaryEstablishmentsPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryEstablishmentsPostBodyLegalStructure
     */
    protected $legalStructure;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var V1VeterinaryEstablishmentsPostBodyMainBillingAccount|null
     */
    protected $mainBillingAccount;

    /**
     * @var string
     */
    protected $privilegedCode;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string|null
     */
    protected $shortDescription;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryEstablishmentsPostBodyLogo|null
     */
    protected $logo;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryEstablishmentsPostBodyBanner|null
     */
    protected $banner;

    /**
     * @var V1VeterinaryEstablishmentsPostBodyPicturesItem[]|null
     */
    protected $pictures;

    /**
     * Schedule - Request Model.
     *
     * @var V1VeterinaryEstablishmentsPostBodySchedule|null
     */
    protected $schedule;

    /**
     * @var V1VeterinaryEstablishmentsPostBodyTagsItem[]|null
     */
    protected $tags;

    /**
     * @var int|null
     */
    protected $entryNumber;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Id - Common Request Model.
     */
    public function getLegalStructure(): V1VeterinaryEstablishmentsPostBodyLegalStructure
    {
        return $this->legalStructure;
    }

    /**
     * Id - Common Request Model.
     */
    public function setLegalStructure(V1VeterinaryEstablishmentsPostBodyLegalStructure $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getMainBillingAccount(): ?V1VeterinaryEstablishmentsPostBodyMainBillingAccount
    {
        return $this->mainBillingAccount;
    }

    public function setMainBillingAccount(?V1VeterinaryEstablishmentsPostBodyMainBillingAccount $mainBillingAccount): self
    {
        $this->initialized['mainBillingAccount'] = true;
        $this->mainBillingAccount = $mainBillingAccount;

        return $this;
    }

    public function getPrivilegedCode(): string
    {
        return $this->privilegedCode;
    }

    public function setPrivilegedCode(string $privilegedCode): self
    {
        $this->initialized['privilegedCode'] = true;
        $this->privilegedCode = $privilegedCode;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getShortDescription(): ?string
    {
        return $this->shortDescription;
    }

    public function setShortDescription(?string $shortDescription): self
    {
        $this->initialized['shortDescription'] = true;
        $this->shortDescription = $shortDescription;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getLogo(): ?V1VeterinaryEstablishmentsPostBodyLogo
    {
        return $this->logo;
    }

    /**
     * Id - Common Request Model.
     */
    public function setLogo(?V1VeterinaryEstablishmentsPostBodyLogo $logo): self
    {
        $this->initialized['logo'] = true;
        $this->logo = $logo;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getBanner(): ?V1VeterinaryEstablishmentsPostBodyBanner
    {
        return $this->banner;
    }

    /**
     * Id - Common Request Model.
     */
    public function setBanner(?V1VeterinaryEstablishmentsPostBodyBanner $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    /**
     * @return V1VeterinaryEstablishmentsPostBodyPicturesItem[]|null
     */
    public function getPictures(): ?array
    {
        return $this->pictures;
    }

    /**
     * @param V1VeterinaryEstablishmentsPostBodyPicturesItem[]|null $pictures
     */
    public function setPictures(?array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }

    /**
     * Schedule - Request Model.
     */
    public function getSchedule(): ?V1VeterinaryEstablishmentsPostBodySchedule
    {
        return $this->schedule;
    }

    /**
     * Schedule - Request Model.
     */
    public function setSchedule(?V1VeterinaryEstablishmentsPostBodySchedule $schedule): self
    {
        $this->initialized['schedule'] = true;
        $this->schedule = $schedule;

        return $this;
    }

    /**
     * @return V1VeterinaryEstablishmentsPostBodyTagsItem[]|null
     */
    public function getTags(): ?array
    {
        return $this->tags;
    }

    /**
     * @param V1VeterinaryEstablishmentsPostBodyTagsItem[]|null $tags
     */
    public function setTags(?array $tags): self
    {
        $this->initialized['tags'] = true;
        $this->tags = $tags;

        return $this;
    }

    public function getEntryNumber(): ?int
    {
        return $this->entryNumber;
    }

    public function setEntryNumber(?int $entryNumber): self
    {
        $this->initialized['entryNumber'] = true;
        $this->entryNumber = $entryNumber;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }
}
