<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1VeterinaryEstablishmentUsersPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $jobTitle;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryEstablishmentUsersPostBodyUser
     */
    protected $user;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryEstablishmentUsersPostBodyVeterinaryEstablishment
     */
    protected $veterinaryEstablishment;

    /**
     * @var \DateTime
     */
    protected $entryDate;

    /**
     * @var \DateTime|null
     */
    protected $exitDate;

    /**
     * @var string[]|null
     */
    protected $departments;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getJobTitle(): string
    {
        return $this->jobTitle;
    }

    public function setJobTitle(string $jobTitle): self
    {
        $this->initialized['jobTitle'] = true;
        $this->jobTitle = $jobTitle;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getUser(): V1VeterinaryEstablishmentUsersPostBodyUser
    {
        return $this->user;
    }

    /**
     * Id - Common Request Model.
     */
    public function setUser(V1VeterinaryEstablishmentUsersPostBodyUser $user): self
    {
        $this->initialized['user'] = true;
        $this->user = $user;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishment(): V1VeterinaryEstablishmentUsersPostBodyVeterinaryEstablishment
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishment(V1VeterinaryEstablishmentUsersPostBodyVeterinaryEstablishment $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }

    public function getEntryDate(): \DateTime
    {
        return $this->entryDate;
    }

    public function setEntryDate(\DateTime $entryDate): self
    {
        $this->initialized['entryDate'] = true;
        $this->entryDate = $entryDate;

        return $this;
    }

    public function getExitDate(): ?\DateTime
    {
        return $this->exitDate;
    }

    public function setExitDate(?\DateTime $exitDate): self
    {
        $this->initialized['exitDate'] = true;
        $this->exitDate = $exitDate;

        return $this;
    }

    /**
     * @return string[]|null
     */
    public function getDepartments(): ?array
    {
        return $this->departments;
    }

    /**
     * @param string[]|null $departments
     */
    public function setDepartments(?array $departments): self
    {
        $this->initialized['departments'] = true;
        $this->departments = $departments;

        return $this;
    }
}
