<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1VeterinaryEstablishmentServiceSubscriptionsIdPutBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var \DateTime
     */
    protected $from;

    /**
     * @var \DateTime
     */
    protected $to;

    /**
     * @var V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyAttributesItem[]
     */
    protected $attributes;

    /**
     * @var string
     */
    protected $billingMethod;

    /**
     * @var bool
     */
    protected $isRenewal;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyBillingAccount|null
     */
    protected $billingAccount;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getFrom(): \DateTime
    {
        return $this->from;
    }

    public function setFrom(\DateTime $from): self
    {
        $this->initialized['from'] = true;
        $this->from = $from;

        return $this;
    }

    public function getTo(): \DateTime
    {
        return $this->to;
    }

    public function setTo(\DateTime $to): self
    {
        $this->initialized['to'] = true;
        $this->to = $to;

        return $this;
    }

    /**
     * @return V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyAttributesItem[]
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @param V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyAttributesItem[] $attributes
     */
    public function setAttributes(array $attributes): self
    {
        $this->initialized['attributes'] = true;
        $this->attributes = $attributes;

        return $this;
    }

    public function getBillingMethod(): string
    {
        return $this->billingMethod;
    }

    public function setBillingMethod(string $billingMethod): self
    {
        $this->initialized['billingMethod'] = true;
        $this->billingMethod = $billingMethod;

        return $this;
    }

    public function getIsRenewal(): bool
    {
        return $this->isRenewal;
    }

    public function setIsRenewal(bool $isRenewal): self
    {
        $this->initialized['isRenewal'] = true;
        $this->isRenewal = $isRenewal;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getBillingAccount(): ?V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyBillingAccount
    {
        return $this->billingAccount;
    }

    /**
     * Id - Common Request Model.
     */
    public function setBillingAccount(?V1VeterinaryEstablishmentServiceSubscriptionsIdPutBodyBillingAccount $billingAccount): self
    {
        $this->initialized['billingAccount'] = true;
        $this->billingAccount = $billingAccount;

        return $this;
    }
}
