<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1VeterinaryEstablishmentServiceDeliveriesPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $code;

    /**
     * @var \DateTime
     */
    protected $completionDate;

    /**
     * @var \DateTime
     */
    protected $invoiceDate;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryEstablishmentServiceDeliveriesPostBodyServiceDeliveryOption
     */
    protected $serviceDeliveryOption;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryEstablishmentServiceDeliveriesPostBodyVeterinaryEstablishment
     */
    protected $veterinaryEstablishment;

    /**
     * @var string|null
     */
    protected $ebpCode;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string|null
     */
    protected $paymentStatus;

    /**
     * @var int|null
     */
    protected $unitPriceWithoutVat;

    /**
     * @var int|null
     */
    protected $vat;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getCompletionDate(): \DateTime
    {
        return $this->completionDate;
    }

    public function setCompletionDate(\DateTime $completionDate): self
    {
        $this->initialized['completionDate'] = true;
        $this->completionDate = $completionDate;

        return $this;
    }

    public function getInvoiceDate(): \DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(\DateTime $invoiceDate): self
    {
        $this->initialized['invoiceDate'] = true;
        $this->invoiceDate = $invoiceDate;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getServiceDeliveryOption(): V1VeterinaryEstablishmentServiceDeliveriesPostBodyServiceDeliveryOption
    {
        return $this->serviceDeliveryOption;
    }

    /**
     * Id - Common Request Model.
     */
    public function setServiceDeliveryOption(V1VeterinaryEstablishmentServiceDeliveriesPostBodyServiceDeliveryOption $serviceDeliveryOption): self
    {
        $this->initialized['serviceDeliveryOption'] = true;
        $this->serviceDeliveryOption = $serviceDeliveryOption;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishment(): V1VeterinaryEstablishmentServiceDeliveriesPostBodyVeterinaryEstablishment
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishment(V1VeterinaryEstablishmentServiceDeliveriesPostBodyVeterinaryEstablishment $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }

    public function getEbpCode(): ?string
    {
        return $this->ebpCode;
    }

    public function setEbpCode(?string $ebpCode): self
    {
        $this->initialized['ebpCode'] = true;
        $this->ebpCode = $ebpCode;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getPaymentStatus(): ?string
    {
        return $this->paymentStatus;
    }

    public function setPaymentStatus(?string $paymentStatus): self
    {
        $this->initialized['paymentStatus'] = true;
        $this->paymentStatus = $paymentStatus;

        return $this;
    }

    public function getUnitPriceWithoutVat(): ?int
    {
        return $this->unitPriceWithoutVat;
    }

    public function setUnitPriceWithoutVat(?int $unitPriceWithoutVat): self
    {
        $this->initialized['unitPriceWithoutVat'] = true;
        $this->unitPriceWithoutVat = $unitPriceWithoutVat;

        return $this;
    }

    public function getVat(): ?int
    {
        return $this->vat;
    }

    public function setVat(?int $vat): self
    {
        $this->initialized['vat'] = true;
        $this->vat = $vat;

        return $this;
    }
}
