<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1VeterinaryEstablishmentServiceDeliveriesIdPatchBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $code;

    /**
     * @var \DateTime|null
     */
    protected $completionDate;

    /**
     * @var string|null
     */
    protected $ebpCode;

    /**
     * @var \DateTime|null
     */
    protected $invoiceDate;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string|null
     */
    protected $paymentStatus;

    /**
     * @var int|null
     */
    protected $unitPriceWithoutVat;

    /**
     * @var int|null
     */
    protected $vat;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getCompletionDate(): ?\DateTime
    {
        return $this->completionDate;
    }

    public function setCompletionDate(?\DateTime $completionDate): self
    {
        $this->initialized['completionDate'] = true;
        $this->completionDate = $completionDate;

        return $this;
    }

    public function getEbpCode(): ?string
    {
        return $this->ebpCode;
    }

    public function setEbpCode(?string $ebpCode): self
    {
        $this->initialized['ebpCode'] = true;
        $this->ebpCode = $ebpCode;

        return $this;
    }

    public function getInvoiceDate(): ?\DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?\DateTime $invoiceDate): self
    {
        $this->initialized['invoiceDate'] = true;
        $this->invoiceDate = $invoiceDate;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getPaymentStatus(): ?string
    {
        return $this->paymentStatus;
    }

    public function setPaymentStatus(?string $paymentStatus): self
    {
        $this->initialized['paymentStatus'] = true;
        $this->paymentStatus = $paymentStatus;

        return $this;
    }

    public function getUnitPriceWithoutVat(): ?int
    {
        return $this->unitPriceWithoutVat;
    }

    public function setUnitPriceWithoutVat(?int $unitPriceWithoutVat): self
    {
        $this->initialized['unitPriceWithoutVat'] = true;
        $this->unitPriceWithoutVat = $unitPriceWithoutVat;

        return $this;
    }

    public function getVat(): ?int
    {
        return $this->vat;
    }

    public function setVat(?int $vat): self
    {
        $this->initialized['vat'] = true;
        $this->vat = $vat;

        return $this;
    }
}
