<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1VeterinaryEstablishmentCreditNotesPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $accountingStatus;

    /**
     * @var string
     */
    protected $documentCode;

    /**
     * @var \DateTime
     */
    protected $documentDate;

    /**
     * @var string
     */
    protected $documentType;

    /**
     * @var V1VeterinaryEstablishmentCreditNotesPostBodyModeration
     */
    protected $moderation;

    /**
     * @var int|null
     */
    protected $unitPriceWithVat;

    /**
     * Id - Common Request Model.
     *
     * @var V1VeterinaryEstablishmentCreditNotesPostBodyVeterinaryEstablishment
     */
    protected $veterinaryEstablishment;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAccountingStatus(): ?string
    {
        return $this->accountingStatus;
    }

    public function setAccountingStatus(?string $accountingStatus): self
    {
        $this->initialized['accountingStatus'] = true;
        $this->accountingStatus = $accountingStatus;

        return $this;
    }

    public function getDocumentCode(): string
    {
        return $this->documentCode;
    }

    public function setDocumentCode(string $documentCode): self
    {
        $this->initialized['documentCode'] = true;
        $this->documentCode = $documentCode;

        return $this;
    }

    public function getDocumentDate(): \DateTime
    {
        return $this->documentDate;
    }

    public function setDocumentDate(\DateTime $documentDate): self
    {
        $this->initialized['documentDate'] = true;
        $this->documentDate = $documentDate;

        return $this;
    }

    public function getDocumentType(): string
    {
        return $this->documentType;
    }

    public function setDocumentType(string $documentType): self
    {
        $this->initialized['documentType'] = true;
        $this->documentType = $documentType;

        return $this;
    }

    public function getModeration(): V1VeterinaryEstablishmentCreditNotesPostBodyModeration
    {
        return $this->moderation;
    }

    public function setModeration(V1VeterinaryEstablishmentCreditNotesPostBodyModeration $moderation): self
    {
        $this->initialized['moderation'] = true;
        $this->moderation = $moderation;

        return $this;
    }

    public function getUnitPriceWithVat(): ?int
    {
        return $this->unitPriceWithVat;
    }

    public function setUnitPriceWithVat(?int $unitPriceWithVat): self
    {
        $this->initialized['unitPriceWithVat'] = true;
        $this->unitPriceWithVat = $unitPriceWithVat;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishment(): V1VeterinaryEstablishmentCreditNotesPostBodyVeterinaryEstablishment
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishment(V1VeterinaryEstablishmentCreditNotesPostBodyVeterinaryEstablishment $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }
}
