<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1RequiredMandatesPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Id - Common Request Model.
     *
     * @var V1RequiredMandatesPostBodyMandate
     */
    protected $mandate;

    /**
     * Id - Common Request Model.
     *
     * @var V1RequiredMandatesPostBodyLegalStructure
     */
    protected $legalStructure;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Id - Common Request Model.
     */
    public function getMandate(): V1RequiredMandatesPostBodyMandate
    {
        return $this->mandate;
    }

    /**
     * Id - Common Request Model.
     */
    public function setMandate(V1RequiredMandatesPostBodyMandate $mandate): self
    {
        $this->initialized['mandate'] = true;
        $this->mandate = $mandate;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getLegalStructure(): V1RequiredMandatesPostBodyLegalStructure
    {
        return $this->legalStructure;
    }

    /**
     * Id - Common Request Model.
     */
    public function setLegalStructure(V1RequiredMandatesPostBodyLegalStructure $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }
}
