<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1PetsPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var bool
     */
    protected $isAnonymous;

    /**
     * @var V1PetsPostBodyMicrochip|null
     */
    protected $microchip;

    /**
     * @var string|null
     */
    protected $name;

    /**
     * @var V1PetsPostBodyTattoo|null
     */
    protected $tattoo;

    /**
     * @var string
     */
    protected $specie;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getIsAnonymous(): bool
    {
        return $this->isAnonymous;
    }

    public function setIsAnonymous(bool $isAnonymous): self
    {
        $this->initialized['isAnonymous'] = true;
        $this->isAnonymous = $isAnonymous;

        return $this;
    }

    public function getMicrochip(): ?V1PetsPostBodyMicrochip
    {
        return $this->microchip;
    }

    public function setMicrochip(?V1PetsPostBodyMicrochip $microchip): self
    {
        $this->initialized['microchip'] = true;
        $this->microchip = $microchip;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getTattoo(): ?V1PetsPostBodyTattoo
    {
        return $this->tattoo;
    }

    public function setTattoo(?V1PetsPostBodyTattoo $tattoo): self
    {
        $this->initialized['tattoo'] = true;
        $this->tattoo = $tattoo;

        return $this;
    }

    public function getSpecie(): string
    {
        return $this->specie;
    }

    public function setSpecie(string $specie): self
    {
        $this->initialized['specie'] = true;
        $this->specie = $specie;

        return $this;
    }
}
