<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1LegalStructuresIdPatchBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $legalForm;

    /**
     * @var string|null
     */
    protected $socialReason;

    /**
     * @var string|null
     */
    protected $legalCode;

    /**
     * @var V1LegalStructuresIdPatchBodyHeadQuarterAddress|null
     */
    protected $headQuarterAddress;

    /**
     * @var string|null
     */
    protected $addressSupplement;

    /**
     * Coordinate - Request Model.
     *
     * @var V1LegalStructuresIdPatchBodyCoordinates|null
     */
    protected $coordinates;

    /**
     * @var string|null
     */
    protected $department;

    /**
     * @var string|null
     */
    protected $entitled;

    /**
     * @var string|null
     */
    protected $postBoxNumber;

    /**
     * @var string|null
     */
    protected $recipientIdentity;

    /**
     * @var string|null
     */
    protected $region;

    /**
     * @var string|null
     */
    protected $apeCode;

    /**
     * @var string|null
     */
    protected $tradeName;

    /**
     * @var string|null
     */
    protected $vatIntraCommunityNumber;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getLegalForm(): ?string
    {
        return $this->legalForm;
    }

    public function setLegalForm(?string $legalForm): self
    {
        $this->initialized['legalForm'] = true;
        $this->legalForm = $legalForm;

        return $this;
    }

    public function getSocialReason(): ?string
    {
        return $this->socialReason;
    }

    public function setSocialReason(?string $socialReason): self
    {
        $this->initialized['socialReason'] = true;
        $this->socialReason = $socialReason;

        return $this;
    }

    public function getLegalCode(): ?string
    {
        return $this->legalCode;
    }

    public function setLegalCode(?string $legalCode): self
    {
        $this->initialized['legalCode'] = true;
        $this->legalCode = $legalCode;

        return $this;
    }

    public function getHeadQuarterAddress(): ?V1LegalStructuresIdPatchBodyHeadQuarterAddress
    {
        return $this->headQuarterAddress;
    }

    public function setHeadQuarterAddress(?V1LegalStructuresIdPatchBodyHeadQuarterAddress $headQuarterAddress): self
    {
        $this->initialized['headQuarterAddress'] = true;
        $this->headQuarterAddress = $headQuarterAddress;

        return $this;
    }

    public function getAddressSupplement(): ?string
    {
        return $this->addressSupplement;
    }

    public function setAddressSupplement(?string $addressSupplement): self
    {
        $this->initialized['addressSupplement'] = true;
        $this->addressSupplement = $addressSupplement;

        return $this;
    }

    /**
     * Coordinate - Request Model.
     */
    public function getCoordinates(): ?V1LegalStructuresIdPatchBodyCoordinates
    {
        return $this->coordinates;
    }

    /**
     * Coordinate - Request Model.
     */
    public function setCoordinates(?V1LegalStructuresIdPatchBodyCoordinates $coordinates): self
    {
        $this->initialized['coordinates'] = true;
        $this->coordinates = $coordinates;

        return $this;
    }

    public function getDepartment(): ?string
    {
        return $this->department;
    }

    public function setDepartment(?string $department): self
    {
        $this->initialized['department'] = true;
        $this->department = $department;

        return $this;
    }

    public function getEntitled(): ?string
    {
        return $this->entitled;
    }

    public function setEntitled(?string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getPostBoxNumber(): ?string
    {
        return $this->postBoxNumber;
    }

    public function setPostBoxNumber(?string $postBoxNumber): self
    {
        $this->initialized['postBoxNumber'] = true;
        $this->postBoxNumber = $postBoxNumber;

        return $this;
    }

    public function getRecipientIdentity(): ?string
    {
        return $this->recipientIdentity;
    }

    public function setRecipientIdentity(?string $recipientIdentity): self
    {
        $this->initialized['recipientIdentity'] = true;
        $this->recipientIdentity = $recipientIdentity;

        return $this;
    }

    public function getRegion(): ?string
    {
        return $this->region;
    }

    public function setRegion(?string $region): self
    {
        $this->initialized['region'] = true;
        $this->region = $region;

        return $this;
    }

    public function getApeCode(): ?string
    {
        return $this->apeCode;
    }

    public function setApeCode(?string $apeCode): self
    {
        $this->initialized['apeCode'] = true;
        $this->apeCode = $apeCode;

        return $this;
    }

    public function getTradeName(): ?string
    {
        return $this->tradeName;
    }

    public function setTradeName(?string $tradeName): self
    {
        $this->initialized['tradeName'] = true;
        $this->tradeName = $tradeName;

        return $this;
    }

    public function getVatIntraCommunityNumber(): ?string
    {
        return $this->vatIntraCommunityNumber;
    }

    public function setVatIntraCommunityNumber(?string $vatIntraCommunityNumber): self
    {
        $this->initialized['vatIntraCommunityNumber'] = true;
        $this->vatIntraCommunityNumber = $vatIntraCommunityNumber;

        return $this;
    }
}
