<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1ImagesPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $dataUri;

    /**
     * @var string
     */
    protected $originalName;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getDataUri(): string
    {
        return $this->dataUri;
    }

    public function setDataUri(string $dataUri): self
    {
        $this->initialized['dataUri'] = true;
        $this->dataUri = $dataUri;

        return $this;
    }

    public function getOriginalName(): string
    {
        return $this->originalName;
    }

    public function setOriginalName(string $originalName): self
    {
        $this->initialized['originalName'] = true;
        $this->originalName = $originalName;

        return $this;
    }
}
