<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1FilledMandatesIdPatchBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Id - Common Request Model.
     *
     * @var V1FilledMandatesIdPatchBodyBillingAccount
     */
    protected $billingAccount;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Id - Common Request Model.
     */
    public function getBillingAccount(): V1FilledMandatesIdPatchBodyBillingAccount
    {
        return $this->billingAccount;
    }

    /**
     * Id - Common Request Model.
     */
    public function setBillingAccount(V1FilledMandatesIdPatchBodyBillingAccount $billingAccount): self
    {
        $this->initialized['billingAccount'] = true;
        $this->billingAccount = $billingAccount;

        return $this;
    }
}
