<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1BillingAccountsPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $bicSwift;

    /**
     * Id - Common Request Model.
     *
     * @var V1BillingAccountsPostBodyFile|null
     */
    protected $file;

    /**
     * @var string|null
     */
    protected $iban;

    /**
     * @var string
     */
    protected $identityName;

    /**
     * Id - Common Request Model.
     *
     * @var V1BillingAccountsPostBodyLegalStructure
     */
    protected $legalStructure;

    /**
     * @var string|null
     */
    protected $signatoryName;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getBicSwift(): ?string
    {
        return $this->bicSwift;
    }

    public function setBicSwift(?string $bicSwift): self
    {
        $this->initialized['bicSwift'] = true;
        $this->bicSwift = $bicSwift;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getFile(): ?V1BillingAccountsPostBodyFile
    {
        return $this->file;
    }

    /**
     * Id - Common Request Model.
     */
    public function setFile(?V1BillingAccountsPostBodyFile $file): self
    {
        $this->initialized['file'] = true;
        $this->file = $file;

        return $this;
    }

    public function getIban(): ?string
    {
        return $this->iban;
    }

    public function setIban(?string $iban): self
    {
        $this->initialized['iban'] = true;
        $this->iban = $iban;

        return $this;
    }

    public function getIdentityName(): string
    {
        return $this->identityName;
    }

    public function setIdentityName(string $identityName): self
    {
        $this->initialized['identityName'] = true;
        $this->identityName = $identityName;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getLegalStructure(): V1BillingAccountsPostBodyLegalStructure
    {
        return $this->legalStructure;
    }

    /**
     * Id - Common Request Model.
     */
    public function setLegalStructure(V1BillingAccountsPostBodyLegalStructure $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    public function getSignatoryName(): ?string
    {
        return $this->signatoryName;
    }

    public function setSignatoryName(?string $signatoryName): self
    {
        $this->initialized['signatoryName'] = true;
        $this->signatoryName = $signatoryName;

        return $this;
    }
}
