<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1BillingAccountsIdPatchBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $bicSwift;

    /**
     * Id - Common Request Model.
     *
     * @var V1BillingAccountsIdPatchBodyFile|null
     */
    protected $file;

    /**
     * @var string|null
     */
    protected $iban;

    /**
     * @var string|null
     */
    protected $identityName;

    /**
     * @var string|null
     */
    protected $signatoryName;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getBicSwift(): ?string
    {
        return $this->bicSwift;
    }

    public function setBicSwift(?string $bicSwift): self
    {
        $this->initialized['bicSwift'] = true;
        $this->bicSwift = $bicSwift;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getFile(): ?V1BillingAccountsIdPatchBodyFile
    {
        return $this->file;
    }

    /**
     * Id - Common Request Model.
     */
    public function setFile(?V1BillingAccountsIdPatchBodyFile $file): self
    {
        $this->initialized['file'] = true;
        $this->file = $file;

        return $this;
    }

    public function getIban(): ?string
    {
        return $this->iban;
    }

    public function setIban(?string $iban): self
    {
        $this->initialized['iban'] = true;
        $this->iban = $iban;

        return $this;
    }

    public function getIdentityName(): ?string
    {
        return $this->identityName;
    }

    public function setIdentityName(?string $identityName): self
    {
        $this->initialized['identityName'] = true;
        $this->identityName = $identityName;

        return $this;
    }

    public function getSignatoryName(): ?string
    {
        return $this->signatoryName;
    }

    public function setSignatoryName(?string $signatoryName): self
    {
        $this->initialized['signatoryName'] = true;
        $this->signatoryName = $signatoryName;

        return $this;
    }
}
