<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ServiceExternalResource extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var array<string, ServicePermission>
     */
    protected $permissions;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return array<string, ServicePermission>
     */
    public function getPermissions(): iterable
    {
        return $this->permissions;
    }

    /**
     * @param array<string, ServicePermission> $permissions
     */
    public function setPermissions(iterable $permissions): self
    {
        $this->initialized['permissions'] = true;
        $this->permissions = $permissions;

        return $this;
    }
}
