<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class PrincipalInvitation extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Principal invited to finish its inscription.
     *
     * @var string
     */
    protected $invited;

    /**
     * Principal inviting the person.
     *
     * @var string|null
     */
    protected $host;

    /**
     * OAuth client used to invite the principal.
     *
     * @var string|null
     */
    protected $hostClient;

    /**
     * @var \DateTime|null
     */
    protected $emailSent;

    /**
     * @var InvitationEmailStatusEnum
     */
    protected $emailStatus;

    /**
     * @var string|null
     */
    protected $emailLog;

    /**
     * @var string|null
     */
    protected $id;

    /**
     * 256-bits encoded in base 36.
     *
     * @var string
     */
    protected $token;

    /**
     * @var \DateTime
     */
    protected $created;

    /**
     * @var int
     */
    protected $emailTemplateNumber = 5135089;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Principal invited to finish its inscription.
     */
    public function getInvited(): string
    {
        return $this->invited;
    }

    /**
     * Principal invited to finish its inscription.
     */
    public function setInvited(string $invited): self
    {
        $this->initialized['invited'] = true;
        $this->invited = $invited;

        return $this;
    }

    /**
     * Principal inviting the person.
     */
    public function getHost(): ?string
    {
        return $this->host;
    }

    /**
     * Principal inviting the person.
     */
    public function setHost(?string $host): self
    {
        $this->initialized['host'] = true;
        $this->host = $host;

        return $this;
    }

    /**
     * OAuth client used to invite the principal.
     */
    public function getHostClient(): ?string
    {
        return $this->hostClient;
    }

    /**
     * OAuth client used to invite the principal.
     */
    public function setHostClient(?string $hostClient): self
    {
        $this->initialized['hostClient'] = true;
        $this->hostClient = $hostClient;

        return $this;
    }

    public function getEmailSent(): ?\DateTime
    {
        return $this->emailSent;
    }

    public function setEmailSent(?\DateTime $emailSent): self
    {
        $this->initialized['emailSent'] = true;
        $this->emailSent = $emailSent;

        return $this;
    }

    public function getEmailStatus(): InvitationEmailStatusEnum
    {
        return $this->emailStatus;
    }

    public function setEmailStatus(InvitationEmailStatusEnum $emailStatus): self
    {
        $this->initialized['emailStatus'] = true;
        $this->emailStatus = $emailStatus;

        return $this;
    }

    public function getEmailLog(): ?string
    {
        return $this->emailLog;
    }

    public function setEmailLog(?string $emailLog): self
    {
        $this->initialized['emailLog'] = true;
        $this->emailLog = $emailLog;

        return $this;
    }

    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId(?string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    /**
     * 256-bits encoded in base 36.
     */
    public function getToken(): string
    {
        return $this->token;
    }

    /**
     * 256-bits encoded in base 36.
     */
    public function setToken(string $token): self
    {
        $this->initialized['token'] = true;
        $this->token = $token;

        return $this;
    }

    public function getCreated(): \DateTime
    {
        return $this->created;
    }

    public function setCreated(\DateTime $created): self
    {
        $this->initialized['created'] = true;
        $this->created = $created;

        return $this;
    }

    public function getEmailTemplateNumber(): int
    {
        return $this->emailTemplateNumber;
    }

    public function setEmailTemplateNumber(int $emailTemplateNumber): self
    {
        $this->initialized['emailTemplateNumber'] = true;
        $this->emailTemplateNumber = $emailTemplateNumber;

        return $this;
    }
}
