<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class PermissionGrant extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string[]
     */
    protected $allowed;

    /**
     * @var string[]
     */
    protected $denied;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return string[]
     */
    public function getAllowed(): array
    {
        return $this->allowed;
    }

    /**
     * @param string[] $allowed
     */
    public function setAllowed(array $allowed): self
    {
        $this->initialized['allowed'] = true;
        $this->allowed = $allowed;

        return $this;
    }

    /**
     * @return string[]
     */
    public function getDenied(): array
    {
        return $this->denied;
    }

    /**
     * @param string[] $denied
     */
    public function setDenied(array $denied): self
    {
        $this->initialized['denied'] = true;
        $this->denied = $denied;

        return $this;
    }
}
