<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class PostResourceCollection extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    protected $accept;

    /**
     * Creates a Resource resource.
     *
     * @param array $accept Accept content header application/json|text/html
     */
    public function __construct(\NoahVet\Reef\Jane\Model\Resource $requestBody, array $accept = [])
    {
        $this->body = $requestBody;
        $this->accept = $accept;
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function getUri(): string
    {
        return '/api/resources';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        if ($this->body instanceof \NoahVet\Reef\Jane\Model\Resource) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        if ($this->body instanceof \NoahVet\Reef\Jane\Model\Resource) {
            return [['Content-Type' => ['text/html']], $this->body];
        }

        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\Resource
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostResourceCollectionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostResourceCollectionUnprocessableEntityException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (201 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\Resource', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PostResourceCollectionBadRequestException($response);
        }
        if (422 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PostResourceCollectionUnprocessableEntityException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
