<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetOneVeterinaryGroup extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    protected $id;

    /**
     * Get a Veterinary Group by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     */
    public function __construct(string $id, array $headerParameters = [])
    {
        $this->id = $id;
        $this->headerParameters = $headerParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return \str_replace(['{id}'], [$this->id], '/v1/veterinary_groups/{id}');
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    protected function getHeadersOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);

        return $optionsResolver;
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupsIdGetResponse200
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetOneVeterinaryGroupBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetOneVeterinaryGroupNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\V1VeterinaryGroupsIdGetResponse200', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetOneVeterinaryGroupBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetOneVeterinaryGroupNotFoundException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
