<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane;

class Client extends \NoahVet\Reef\Jane\Runtime\Client\Client
{
    /**
     * Get AssetsA.
     *
     * @param string $a     the dynamic name
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsABadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsANotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAssetsA(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAssetsA($a), $fetch);
    }

    /**
     * Get AssetsAB.
     *
     * @param string $a     the dynamic name
     * @param string $b     the dynamic name
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsABBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsABNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAssetsAB(string $a, string $b, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAssetsAB($a, $b), $fetch);
    }

    /**
     * Get AssetsABC.
     *
     * @param string $a     the dynamic name
     * @param string $b     the dynamic name
     * @param string $c     the dynamic name
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsABCBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsABCNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAssetsABC(string $a, string $b, string $c, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAssetsABC($a, $b, $c), $fetch);
    }

    /**
     * Get AssetsABCD.
     *
     * @param string $a     the dynamic name
     * @param string $b     the dynamic name
     * @param string $c     the dynamic name
     * @param string $d     the dynamic name
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsABCDBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsABCDNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAssetsABCD(string $a, string $b, string $c, string $d, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAssetsABCD($a, $b, $c, $d), $fetch);
    }

    /**
     * List Billing Accounts.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $legalStructureId[] Filter by legalStructureId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1BillingAccountsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1BillingAccountsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllBillingAccountBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllBillingAccount(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllBillingAccount($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Billing Account.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1BillingAccountsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostBillingAccountBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postBillingAccount(Model\V1BillingAccountsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostBillingAccount($requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Billing Account by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1BillingAccountsIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneBillingAccountBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneBillingAccountNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneBillingAccount(string $id, Model\V1BillingAccountsIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneBillingAccount($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Filled Mandate by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1FilledMandatesIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneFilledMandateBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneFilledMandateNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneFilledMandate(string $id, Model\V1FilledMandatesIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneFilledMandate($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Get a Mandate by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept langage for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1MandatesIdGetResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetOneMandateBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetOneMandateNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getOneMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetOneMandate($id, $headerParameters), $fetch);
    }

    /**
     * Get an image preview of Filled Mandate by Legal Structure Id.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept langage for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetOneImagePreviewFilledMandateBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetOneImagePreviewFilledMandateNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getOneImagePreviewFilledMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetOneImagePreviewFilledMandate($id, $headerParameters), $fetch);
    }

    /**
     * Get a Yousign Signature Request by Legal Structure Id.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept langage for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1LegalStructuresIdYousignSignatureRequestsGetResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetOneYousignSignatureRequestBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetOneYousignSignatureRequestNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getOneYousignSignatureRequest(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetOneYousignSignatureRequest($id, $headerParameters), $fetch);
    }

    /**
     * Confirma a Yousign Signature Request by Legal Structure Id.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept langage for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetOneYousignSignatureRequestConfirmationBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetOneYousignSignatureRequestConfirmationNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getOneYousignSignatureRequestConfirmation(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetOneYousignSignatureRequestConfirmation($id, $headerParameters), $fetch);
    }

    /**
     * List Invitations.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $hostUserId[] Filter by hostUserId
     * @var array  $invitedUserId[] Filter by invitedUserId
     * @var array  $status[] Filter by status
     * @var array  $type[] Filter by type
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromExpirationDate[] Filter from expirationDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toExpirationDate[] Filter to expirationDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortExpirationDate Sort by expirationDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1InvitationsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1InvitationsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllInvitationBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllInvitation(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllInvitation($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Send a new email invitation.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept langage for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\RemindInvitationNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function remindInvitation(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\RemindInvitation($id, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment User Invitation.
     * A Veterinary Establishment User Invitations is an invitation to join a veterinary establishment.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUserInvitationsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserInvitationBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserInvitationConflictException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentUserInvitation(Model\V1VeterinaryEstablishmentUserInvitationsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishmentUserInvitation($requestBody, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment User Invitation Confirmation.
     * A Veterinary Establishment User Invitation Confirmation is an confirmation to join or not a veterinary establishment.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUserInvitationConfirmationsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserInvitationConfirmationGoneException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentUserInvitationConfirmation(Model\V1VeterinaryEstablishmentUserInvitationConfirmationsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishmentUserInvitationConfirmation($requestBody, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Group User Invitation.
     * A Veterinary Group User Invitations is an invitation to join a veterinary group.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupUserInvitationsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryGroupUserInvitationBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryGroupUserInvitationConflictException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryGroupUserInvitation(Model\V1VeterinaryGroupUserInvitationsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryGroupUserInvitation($requestBody, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Group User Invitation Confirmation.
     * A Veterinary Group User Invitation Confirmation is an confirmation to join or not a veterinary group.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupUserInvitationConfirmationsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryGroupUserInvitationConfirmationBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryGroupUserInvitationConfirmationNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryGroupUserInvitationConfirmationGoneException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryGroupUserInvitationConfirmation(Model\V1VeterinaryGroupUserInvitationConfirmationsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryGroupUserInvitationConfirmation($requestBody, $headerParameters), $fetch);
    }

    /**
     * List Legal Structures.
     * A legal structure is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId
     * @var array  $veterinaryGroupId[] Filter by veterinaryGroupId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1LegalStructuresGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1LegalStructuresGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllLegalStructureBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllLegalStructure(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllLegalStructure($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Legal Structure.
     *
     * A legal structure is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1LegalStructuresPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostLegalStructureBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postLegalStructure(Model\V1LegalStructuresPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostLegalStructure($requestBody, $headerParameters), $fetch);
    }

    /**
     * Get a Legal Structure by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1LegalStructuresIdGetResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetOneLegalStructureBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetOneLegalStructureNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getOneLegalStructure(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetOneLegalStructure($id, $headerParameters), $fetch);
    }

    /**
     * Update a Legal Structure by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1LegalStructuresIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneLegalStructureBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneLegalStructureNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneLegalStructure(string $id, Model\V1LegalStructuresIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneLegalStructure($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Search on Legal Structures.
     * A legal structure is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1LegalStructuresSearchPostResponse200Item[]|\NoahVet\Reef\Jane\Model\V1LegalStructuresSearchPostResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\SearchLegalStructureBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function searchLegalStructure(Model\V1LegalStructuresSearchPostBody $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\SearchLegalStructure($requestBody, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Manufacturers.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $code[] Filter by code
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1ManufacturersGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1ManufacturersGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllManufacturerBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllManufacturer(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllManufacturer($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Documents.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1DocumentsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1DocumentsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllDocumentsBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllDocuments(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllDocuments($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Document. A Document represents pdf file.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1DocumentsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostDocumentBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postDocument(Model\V1DocumentsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostDocument($requestBody, $headerParameters), $fetch);
    }

    /**
     * List Images.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1ImagesGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1ImagesGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllImagesBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllImages(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllImages($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Image. A Image represents gif, jpeg or png file.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1ImagesPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostImageBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postImage(Model\V1ImagesPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostImage($requestBody, $headerParameters), $fetch);
    }

    /**
     * Create a Required Mandate.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1RequiredMandatesPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostRequiredMandateBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postRequiredMandate(Model\V1RequiredMandatesPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostRequiredMandate($requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Service Deliveries.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryServiceId[] Filter by veterinaryServiceId
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $serviceDeliveryOptionType[] Filter by serviceDeliveryOptionType
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortCode sort by code
     * @var string $sortCompletionDate sort by completionDate
     * @var string $sortEbpCode sort by EbpCode
     * @var string $sortInvoiceDate sort by invoiceDate
     * @var string $sortPaymentStatus sort by paymentStatus
     * @var string $sortUnitPriceWithoutVat sort by unitPriceWithoutVat
     * @var string $sortUnitPriceWithVat sort by unitPriceWithVat
     * @var string $sortVeterinaryServiceEntitled Sort by veterinaryServiceEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceDeliveriesGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceDeliveriesGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentServiceDelivery(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryEstablishmentServiceDelivery($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a VeterinaryEstablishmentServiceDelivery.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceDeliveriesPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentServiceDelivery(Model\V1VeterinaryEstablishmentServiceDeliveriesPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishmentServiceDelivery($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment Service Delivery.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentServiceDeliveryNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentServiceDelivery(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\DeleteOneVeterinaryEstablishmentServiceDelivery($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment Service Delivery by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceDeliveriesIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentServiceDeliveryNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentServiceDelivery(string $id, Model\V1VeterinaryEstablishmentServiceDeliveriesIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneVeterinaryEstablishmentServiceDelivery($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Service Delivery Options.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryServiceId[] Filter by veterinaryServiceId
     * @var array  $type[] Filter by type
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortEbpCode sort by EbpCode
     * @var string $sortEntitled sort by Entitled
     * @var string $sortType sort by type
     * @var string $sortUnitPriceWithoutVat sort by unitPriceWithoutVat
     * @var string $sortUnitPriceWithVat sort by unitPriceWithVat
     * @var string $sortVeterinaryServiceEntitled Sort by veterinaryServiceEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1ServiceDeliveryOptionsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1ServiceDeliveryOptionsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllServiceDeliveryOptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllServiceDeliveryOption(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllServiceDeliveryOption($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a ServiceDeliveryOption.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1ServiceDeliveryOptionsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostServiceDeliveryOptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postServiceDeliveryOption(Model\V1ServiceDeliveryOptionsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostServiceDeliveryOption($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Service Delivery Option.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneServiceDeliveryOptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneServiceDeliveryOptionNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function deleteOneServiceDeliveryOption(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\DeleteOneServiceDeliveryOption($id, $headerParameters), $fetch);
    }

    /**
     * Update a Service Delivery Option by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1ServiceDeliveryOptionsIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneServiceDeliveryOptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneServiceDeliveryOptionNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneServiceDeliveryOption(string $id, Model\V1ServiceDeliveryOptionsIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneServiceDeliveryOption($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Manufacturer Users.
     * A Manufacturer User s a member of the Manufacturer.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $department[] Filter by veterinary establishment department
     * @var array  $jobTitle[] Filter by jobTitle
     * @var array  $userId[] Filter by userId
     * @var array  $manufacturerId[] Filter by manufacturerId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllManufacturerUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllManufacturerUser(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllManufacturerUser($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Users.
     * A Veterinary Establishment User s a member of the Veterinary Establishment.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $department[] Filter by veterinary establishment department
     * @var array  $jobTitle[] Filter by jobTitle
     * @var array  $userId[] Filter by userId
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromEntryDate[] Filter from entryDate
     * @var array  $fromExitDate[] Filter from exitDate
     * @var array  $fromServicePeriodStartDate[] Filter from servicePeriodStartDate
     * @var array  $fromServicePeriodEndDate[] Filter from servicePeriodEndDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toEntryDate[] Filter to entryDate
     * @var array  $toExitDate[] Filter to exitDate
     * @var array  $toServicePeriodStartDate[] Filter to servicePeriodStartDate
     * @var array  $toServicePeriodEndDate[] Filter to servicePeriodEndDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortEntryDate sort by entryDate
     * @var string $sortExitDate sort by exitDate
     * @var string $sortJobTitle Sort by jobTitle.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentUser(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryEstablishmentUser($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment User.
     * A Veterinary Establishment User is a member of the Veterinary Establishment.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentUserConflictException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentUser(Model\V1VeterinaryEstablishmentUsersPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishmentUser($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment User.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentUserNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentUserGoneException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentUser(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\DeleteOneVeterinaryEstablishmentUser($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment User by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentUserNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentUserGoneException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentUser(string $id, Model\V1VeterinaryEstablishmentUsersIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneVeterinaryEstablishmentUser($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Group Users.
     * A Veterinary Group User s a member of the Veterinary Group.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $department[] Filter by veterinary group department
     * @var array  $jobTitle[] Filter by jobTitle
     * @var array  $userId[] Filter by userId
     * @var array  $veterinaryGroupId[] Filter by veterinaryGroupId
     * @var array  $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromEntryDate[] Filter from entryDate
     * @var array  $fromExitDate[] Filter from exitDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toEntryDate[] Filter to entryDate
     * @var array  $toExitDate[] Filter to exitDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortEntryDate sort by entryDate
     * @var string $sortExitDate sort by exitDate
     * @var string $sortJobTitle Sort by jobTitle.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupUsersGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryGroupUsersGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryGroupUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryGroupUser(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryGroupUser($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Group User.
     * A Veterinary Group User s a member of the Veterinary Group.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupUsersPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryGroupUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryGroupUser(Model\V1VeterinaryGroupUsersPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryGroupUser($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Group User.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryGroupUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryGroupUserNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryGroupUserGoneException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryGroupUser(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\DeleteOneVeterinaryGroupUser($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Group User by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupUsersIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryGroupUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryGroupUserNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryGroupUserGoneException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryGroupUser(string $id, Model\V1VeterinaryGroupUsersIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneVeterinaryGroupUser($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishments.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var bool   $isRegularized filter by regularized organisation (Veterinary Establishment or Veterinary Group)
     * @var array  $veuJobTitle[] Filter by jobTitle of veterinary establishment user
     * @var array  $id[] Filter by id
     * @var array  $veuUserId[] Filter by userId of Veterinary Establishment User
     * @var array  $name[] Filter by name
     * @var array  $privilegedCode[] Filter by privilegedCode
     * @var array  $type[] Filter by type
     * @var array  $tag[] Filter by tag
     * @var array  $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortEntryNumber sort by entryNumber
     * @var string $sortName sort by name
     * @var string $sortPrivilegedCode sort by privilegedCode
     * @var string $sortType sort by type
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishment(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryEstablishment($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment.
     * This endpoint will also create a Veterinary Establishment.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishment(Model\V1VeterinaryEstablishmentsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishment($requestBody, $headerParameters), $fetch);
    }

    /**
     * Export Veterinary Establishments.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\ExportVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function exportVeterinaryEstablishment(array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\ExportVeterinaryEstablishment($headerParameters), $fetch);
    }

    /**
     * Get a Veterinary Establishment by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsIdGetResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetOneVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetOneVeterinaryEstablishmentNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getOneVeterinaryEstablishment(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetOneVeterinaryEstablishment($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishment(string $id, Model\V1VeterinaryEstablishmentsIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneVeterinaryEstablishment($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Search on Veterinary Establishments.
     * A veterinary establishment is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $name[] Filter by name
     * @var array  $privilegedCode[] Filter by privilegedCode
     * @var array  $type[] Filter by type
     * @var array  $tag[] Filter by tag
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortEntryNumber sort by entryNumber
     * @var string $sortName sort by name
     * @var string $sortPrivilegedCode sort by privilegedCode
     * @var string $sortType sort by type
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsSearchPostResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsSearchPostResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\SearchVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function searchVeterinaryEstablishment(Model\V1VeterinaryEstablishmentsSearchPostBody $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\SearchVeterinaryEstablishment($requestBody, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment Address.
     * This endpoint will create a Veterinary Establishment Address and add it in the Veterinary Establishment Address list.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentAddressesPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentAddressBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentAddress(Model\V1VeterinaryEstablishmentAddressesPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishmentAddress($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment Address.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentAddressBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentAddressNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentAddress(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\DeleteOneVeterinaryEstablishmentAddress($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment Address by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentAddressesIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentAddressBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentAddressNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentAddress(string $id, Model\V1VeterinaryEstablishmentAddressesIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneVeterinaryEstablishmentAddress($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Credit Notes.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $moderationUserId[] Filter by moderationUserId
     * @var array  $accountingStatus[] Filter by accountingStatus
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentCreditNotesGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentCreditNotesGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentCreditNote(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryEstablishmentCreditNote($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment Credit Note.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentCreditNotesPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentCreditNote(Model\V1VeterinaryEstablishmentCreditNotesPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishmentCreditNote($requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment Credit Note by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentCreditNotesIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentCreditNoteNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentCreditNote(string $id, Model\V1VeterinaryEstablishmentCreditNotesIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneVeterinaryEstablishmentCreditNote($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a lot of Veterinary Establishment Credit Note.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateVeterinaryEstablishmentCreditNoteBulkBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateVeterinaryEstablishmentCreditNoteBulkNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateVeterinaryEstablishmentCreditNoteBulk(Model\V1VeterinaryEstablishmentCreditNotesBulkPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateVeterinaryEstablishmentCreditNoteBulk($requestBody, $headerParameters), $fetch);
    }

    /**
     * Export Veterinary Establishment Credit Notes.
     *
     * @param array $queryParameters {
     *
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $moderationUserId[] Filter by moderationUserId
     * @var array  $accountingStatus[] Filter by accountingStatus
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\ExportVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function exportVeterinaryEstablishmentCreditNote(array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\ExportVeterinaryEstablishmentCreditNote($queryParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Members.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryEstablishmentName[] Filter by veterinaryEstablishmentName
     * @var array  $veterinaryEstablishmentPrivilegedCode[] Filter by veterinaryEstablishmentPrivilegedCode
     * @var array  $veterinaryGroupId[] Filter by veterinaryGroupId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortVeterinaryEstablishmentName Sort by veterinaryEstablishmentName.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentMembersGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentMembersGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentMemberBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentMember(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryEstablishmentMember($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment Member.
     * A Veterinary Establishment Member is the association of an Veterinary Establishment within a Veterinary Group.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentMembersPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentMemberBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentMember(Model\V1VeterinaryEstablishmentMembersPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishmentMember($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment Member.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentMemberBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentMemberNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentMember(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\DeleteOneVeterinaryEstablishmentMember($id, $headerParameters), $fetch);
    }

    /**
     * Search on Veterinary Establishment Members.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryEstablishmentName[] Filter by veterinaryEstablishmentName
     * @var array  $veterinaryEstablishmentPrivilegedCode[] Filter by veterinaryEstablishmentPrivilegedCode
     * @var array  $veterinaryGroupId[] Filter by veterinaryGroupId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortVeterinaryEstablishmentName Sort by veterinaryEstablishmentName.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentMembersSearchPostResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentMembersSearchPostResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\SearchVeterinaryEstablishmentMemberBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function searchVeterinaryEstablishmentMember(Model\V1VeterinaryEstablishmentMembersSearchPostBody $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\SearchVeterinaryEstablishmentMember($requestBody, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * List VeterinaryEstablishmentServicePeriods.
     * A VeterinaryEstablishmentServicePeriod represents a period, a contract with a fixed duration for an
     * establishment to a set of service options.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryEstablishmentServiceSubscriptionId[] Filter by veterinaryEstablishmentServiceSubscriptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromStartDate[] Filter from startDate
     * @var array  $fromEndDate[] Filter from endDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toStartDate[] Filter to startDate
     * @var array  $toEndDate[] Filter to endDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortStartDate sort by startDate
     * @var string $sortEndDate sort by endDate
     * @var string $sortVeterinaryServiceOptionEntitled Sort by veterinaryServiceOptionEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServicePeriodsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServicePeriodsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentServicePeriodBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentServicePeriod(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryEstablishmentServicePeriod($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List VeterinaryEstablishmentServiceSubscriptions.
     * A VeterinaryEstablishmentServiceSubscription represents a subscription, a contract with a fixed duration for an
     * establishment to a set of service options.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromStartDate[] Filter from startDate
     * @var array  $fromEndDate[] Filter from endDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toStartDate[] Filter to startDate
     * @var array  $toEndDate[] Filter to endDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortVeterinaryServiceOptionEntitled Sort by veterinaryServiceOptionEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceSubscriptionsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentServiceSubscription(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryEstablishmentServiceSubscription($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a VeterinaryEstablishmentServiceSubscription.
     * A VeterinaryEstablishmentServiceSubscription represents a subscription, a contract with a fixed duration for an
     * establishment to a set of service options.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceSubscriptionsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentServiceSubscription(Model\V1VeterinaryEstablishmentServiceSubscriptionsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishmentServiceSubscription($requestBody, $headerParameters), $fetch);
    }

    /**
     * Reduce a Veterinary Establishment Service Subscription by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\ReduceOneVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\ReduceOneVeterinaryEstablishmentServiceSubscriptionNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function reduceOneVeterinaryEstablishmentServiceSubscription(string $id, Model\V1VeterinaryEstablishmentServiceSubscriptionsIdReductionPutBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\ReduceOneVeterinaryEstablishmentServiceSubscription($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment Service Subscription.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\DeleteOneVeterinaryEstablishmentServiceSubscriptionNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentServiceSubscription(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\DeleteOneVeterinaryEstablishmentServiceSubscription($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment Service Subscription by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentServiceSubscriptionsIdPutResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryEstablishmentServiceSubscriptionNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentServiceSubscription(string $id, Model\V1VeterinaryEstablishmentServiceSubscriptionsIdPutBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneVeterinaryEstablishmentServiceSubscription($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Tags.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentTagsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentTagsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentTagBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentTag(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryEstablishmentTag($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment Tag.
     * This endpoint will also create a Veterinary Establishment Tag.
     * A tag makes it possible to categorise a set of veterinary establishments around a keyword.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentTagsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentTagBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentTag(Model\V1VeterinaryEstablishmentTagsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryEstablishmentTag($requestBody, $headerParameters), $fetch);
    }

    /**
     * Get a Veterinary Establishment Tag by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentTagsIdGetResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetOneVeterinaryEstablishmentTagBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetOneVeterinaryEstablishmentTagNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getOneVeterinaryEstablishmentTag(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetOneVeterinaryEstablishmentTag($id, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Groups.
     * A Veterinary Group is a network of Veterinary Establishments.
     * A Veterinary Establishment may belong to several Veterinary Groups.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var bool   $isRegularized filter by regularized organisation (Veterinary Establishment or Veterinary Group)
     * @var array  $vguUser[] Filter by jobTitle of veterinary group user
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $vguUserId[] Filter by userId of Veterinary Group User
     * @var array  $entitled[] Filter by entitled
     * @var array  $groupCode[] Filter by groupCode
     * @var array  $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortEntryNumber sort by entryNumber
     * @var string $sortGroupCode sort by groupCode
     * @var string $sortName sort by name
     * @var string $sortType sort by type
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryGroupsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryGroupBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryGroup(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryGroup($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Group.
     * A Veterinary Group is a network of Veterinary Establishments.
     * A Veterinary Establishment may belong to several Veterinary Groups.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryGroupBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryGroup(Model\V1VeterinaryGroupsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostVeterinaryGroup($requestBody, $headerParameters), $fetch);
    }

    /**
     * Get a Veterinary Group by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupsIdGetResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetOneVeterinaryGroupBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetOneVeterinaryGroupNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getOneVeterinaryGroup(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetOneVeterinaryGroup($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Group by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupsIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UpdateOneVeterinaryGroupNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryGroup(string $id, Model\V1VeterinaryGroupsIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\UpdateOneVeterinaryGroup($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Search on Veterinary Groups.
     * A veterinary group is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $entitled[] Filter by entitled
     * @var array  $groupCode[] Filter by groupCode
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortEntryNumber sort by entryNumber
     * @var string $sortGroupCode sort by groupCode
     * @var string $sortName sort by name
     * @var string $sortType sort by type
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryGroupsSearchPostResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryGroupsSearchPostResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\SearchVeterinaryGroupBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function searchVeterinaryGroup(Model\V1VeterinaryGroupsSearchPostBody $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\SearchVeterinaryGroup($requestBody, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Services.
     * A veterinary service could be MyVetshop, Crockit, VetoPartner...
     * Each veterinary service proposes one or more options that can be subscribed to by an veterinary establishment or
     * a veterinary group. A service cannot be created through the api as it requires integration of the service into the
     * reef eco-system.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryServiceOptionStatus[]
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryServicesGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryServicesGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryServiceBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryService(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryService($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Service Options.
     * A veterinary service option could be access to an online shop, to negotiating pricing.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryServiceId[] Filter by veterinaryServiceId
     * @var array  $status[]
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortEntitled Sort by Entitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryServiceOptionsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryServiceOptionsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryServiceOptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryServiceOption(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryServiceOption($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List VeterinaryServiceOptionConfigs.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1VeterinaryServiceOptionConfigsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1VeterinaryServiceOptionConfigsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryServiceOptionConfigBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryServiceOptionConfig(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllVeterinaryServiceOptionConfig($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Pets.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1PetsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllPetBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getAllPet(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetAllPet($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create an Pet.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostPetBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postPet(Model\V1PetsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostPet($requestBody, $headerParameters), $fetch);
    }

    /**
     * Retrieves a Client resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\ClientGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetClientItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getClientItem(string $slug, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetClientItem($slug, $accept), $fetch);
    }

    /**
     * Update client resources types and allowed permissions.
     *
     * @param string $slug             Resource identifier
     * @param array  $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\PutDefinitionClientItemBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PutDefinitionClientItemUnprocessableEntityException
     * @throws \NoahVet\Reef\Jane\Exception\PutDefinitionClientItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function putDefinitionClientItem(string $slug, Model\ServiceDefinition $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PutDefinitionClientItem($slug, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List policy results stored in the IAM.
     *
     * @param array $queryParameters {
     *
     * @var int    $page The collection page number
     * @var int    $itemsPerPage The number of items per page
     * @var string $name
     * @var array  $name[]
     * @var string $subject
     * @var array  $subject[]
     * @var string $etag
     * @var array  $etag[]
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultGet[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getPolicyResultCollection(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetPolicyResultCollection($queryParameters, $headerParameters, $accept), $fetch);
    }

    /**
     * Store a policy result in the IAM.
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostPolicyResultCollectionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostPolicyResultCollectionUnprocessableEntityException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postPolicyResultCollection(Model\PolicyResultPolicyResultPost $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostPolicyResultCollection($requestBody, $headerParameters, $accept), $fetch);
    }

    /**
     * Get a specific policy result.
     *
     * @param string $id               Resource identifier
     * @param array  $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetPolicyResultItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getPolicyResultItem(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetPolicyResultItem($id, $headerParameters, $accept), $fetch);
    }

    /**
     * Retrieves the collection of Principal resources.
     *
     * @param array $queryParameters {
     *
     * @var int    $page The collection page number
     * @var int    $itemsPerPage The number of items per page
     * @var string $email
     * @var string $status
     * @var array  $status[]
     * @var string $id
     * @var string $id[]
     * @var string $order[id]
     * @var string $order[email]
     * @var string $order[created]
     * @var string $order[updated]
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getPrincipalCollection(array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetPrincipalCollection($queryParameters), $fetch);
    }

    /**
     * Invite a person to join the reef by validating a pre-created account.
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostPrincipalCollectionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostPrincipalCollectionUnprocessableEntityException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postPrincipalCollection(Model\PrincipalShort $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostPrincipalCollection($requestBody, $headerParameters), $fetch);
    }

    /**
     * Retrieves a Principal resource.
     *
     * @param string $id    Resource identifier
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetPrincipalItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getPrincipalItem(string $id, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetPrincipalItem($id), $fetch);
    }

    /**
     * Update a principal.
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PutPrincipalItemBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PutPrincipalItemUnprocessableEntityException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function putPrincipalItem(Model\PrincipalPut $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PutPrincipalItem($requestBody), $fetch);
    }

    /**
     * Create a resource group.
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceGroupGet|\Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getResourceGroupCollection(Model\ResourceGroupPost $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetResourceGroupCollection($requestBody), $fetch);
    }

    /**
     * Read a resource group.
     *
     * @param string $slug  Resource group slug
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceGroupGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetResourceGroupItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getResourceGroupItem(string $slug, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetResourceGroupItem($slug), $fetch);
    }

    /**
     * Update a resource group.
     *
     * @param string $slug  Resource group slug
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceGroupGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PutResourceGroupItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function putResourceGroupItem(string $slug, Model\ResourceGroupPut $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PutResourceGroupItem($slug, $requestBody), $fetch);
    }

    /**
     * Retrieves a ResourceGroup resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceGroupResourceGroupGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetPermissionsResourceGroupItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getPermissionsResourceGroupItem(string $slug, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetPermissionsResourceGroupItem($slug, $accept), $fetch);
    }

    /**
     * Retrieves a ResourceType resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceTypeGetshort|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetResourceTypeItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getResourceTypeItem(string $slug, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetResourceTypeItem($slug, $accept), $fetch);
    }

    /**
     * Retrieve effective permissions on alle resources a the specified resource type.
     *
     * @param string $slug            Resource identifier
     * @param array  $queryParameters {
     *
     * @var string $principal Principal ID (if different from the one doing the query)
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetDetailedPermissionsResourceTypeItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getDetailedPermissionsResourceTypeItem(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetDetailedPermissionsResourceTypeItem($slug, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * Retrieves a ResourceType resource.
     *
     * @param string $slug            Resource identifier
     * @param array  $queryParameters {
     *
     * @var string $principal Principal ID (if different from the one doing the query)
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetPermissionsResourceTypeItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getPermissionsResourceTypeItem(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetPermissionsResourceTypeItem($slug, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * Retrieves the collection of Resource resources.
     *
     * @param array $queryParameters {
     *
     * @var int    $page The collection page number
     * @var int    $itemsPerPage The number of items per page
     * @var string $slug
     * @var array  $slug[]
     *             }
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\Resource[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getResourceCollection(array $queryParameters = [], string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetResourceCollection($queryParameters, $accept), $fetch);
    }

    /**
     * Creates a Resource resource.
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\Resource|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostResourceCollectionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostResourceCollectionUnprocessableEntityException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function postResourceCollection(Model\Resource $requestBody, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PostResourceCollection($requestBody, $accept), $fetch);
    }

    /**
     * Retrieve effective permissions on a collection of resources.
     *
     * @param array $queryParameters {
     *
     * @var array  $slug[] List of resources you want permissions for
     * @var string $principal Principal ID (if different from the one doing the query)
     * @var int    $page The collection page number
     * @var int    $itemsPerPage The number of items per page
     * @var string $slug
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getPermissionsResourceCollection(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetPermissionsResourceCollection($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\Resource|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetResourceItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getResourceItem(string $slug, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetResourceItem($slug, $accept), $fetch);
    }

    /**
     * Replaces the Resource resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\Resource|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\PutResourceItemBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PutResourceItemUnprocessableEntityException
     * @throws \NoahVet\Reef\Jane\Exception\PutResourceItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function putResourceItem(string $slug, Model\Resource $requestBody, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\PutResourceItem($slug, $requestBody, $accept), $fetch);
    }

    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug             Resource identifier
     * @param array  $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrant|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetDetailedPermissionsResourceItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getDetailedPermissionsResourceItem(string $slug, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetDetailedPermissionsResourceItem($slug, $headerParameters), $fetch);
    }

    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug            Resource identifier
     * @param array  $queryParameters {
     *
     * @var string $principal Principal ID (if different from the one doing the query)
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrant|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetPermissionsResourceItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function getPermissionsResourceItem(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\GetPermissionsResourceItem($slug, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws \NoahVet\Reef\Jane\Exception\RevokeBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function revoke(string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\Revoke(), $fetch);
    }

    /**
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\UserinfoGetResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws \NoahVet\Reef\Jane\Exception\UserinfoUnauthorizedException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    public function userinfo(string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\Reef\Jane\Endpoint\Userinfo(), $fetch);
    }

    public static function create($httpClient = null, array $additionalPlugins = [], array $additionalNormalizers = [])
    {
        if (null === $httpClient) {
            $httpClient = \Http\Discovery\Psr18ClientDiscovery::find();
            $plugins = [];
            if (0 < \count($additionalPlugins)) {
                $plugins = \array_merge($plugins, $additionalPlugins);
            }
            $httpClient = new \Http\Client\Common\PluginClient($httpClient, $plugins);
        }
        $requestFactory = \Http\Discovery\Psr17FactoryDiscovery::findRequestFactory();
        $streamFactory = \Http\Discovery\Psr17FactoryDiscovery::findStreamFactory();
        $normalizers = [new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \NoahVet\Reef\Jane\Normalizer\JaneObjectNormalizer()];
        if (0 < \count($additionalNormalizers)) {
            $normalizers = \array_merge($normalizers, $additionalNormalizers);
        }
        $serializer = new \Symfony\Component\Serializer\Serializer($normalizers, [new \Symfony\Component\Serializer\Encoder\JsonEncoder(new \Symfony\Component\Serializer\Encoder\JsonEncode(), new \Symfony\Component\Serializer\Encoder\JsonDecode(['json_decode_associative' => true]))]);

        return new static($httpClient, $requestFactory, $serializer, $streamFactory);
    }
}
