<?php

declare(strict_types=1);

namespace NoahVet\Reef\Factory;

use Jane\Component\OpenApiRuntime\Client\Plugin\AuthenticationRegistry;
use NoahVet\Reef\Jane\Authentication\BearerAuthAuthentication;
use NoahVet\Reef\Jane\Client;
use NoahVet\Reef\Plugin\ConfigureUrlPlugin;

class ClientFactory implements ClientFactoryInterface
{
    protected string $url;

    public function __construct(
        string $reefUrl,
    ) {
        $this->url = $reefUrl;
    }

    public function create(string $bearerToken): Client
    {
        $authPlugins = [new BearerAuthAuthentication($bearerToken)];

        return Client::create(
            null,
            [
                new AuthenticationRegistry($authPlugins),
                new ConfigureUrlPlugin($this->url),
            ],
        );
    }
}
