<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

interface VatToolInterface extends ToolInterface
{
    /**
     * E.g.
     *
     * Before
     *
     * 820000 (8200 €) | 2000 percent
     *
     * After
     *
     * 984000 (9840 €, 1640€ added)
     */
    public static function addVat(int $amount, int $vatAmount): int;

    /**
     * E.g.
     *
     * Before
     *
     * 984000 (9840 €) | 2000 percent
     *
     * After
     *
     * 820000 (8200 €, 1640€ removed)
     */
    public static function removeVat(int $amount, int $vatAmount): int;
}
