<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

interface StringToolInterface extends ToolInterface
{
    /**
     * Before.
     *
     * hello-world
     *
     * After
     *
     * hello_world
     */
    public static function fromBurgerCaseToSnakeCase(string $string): string;

    /**
     * Before.
     *
     * A MAJ CHAIN
     *
     * After
     *
     * A Maj Chain
     */
    public static function fromSpacedToPascalCase(string $string): string;

    /**
     * Before.
     *
     * HelloWorld
     *
     * After
     *
     * helloWorld
     */
    public static function fromPascalCaseToCamelCase(string $string): string;
}
