<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

final class StringTool implements StringToolInterface
{
    public static function fromBurgerCaseToSnakeCase(string $string): string
    {
        return \strtolower(\str_replace('-', '_', \trim($string)));
    }

    public static function fromSpacedToPascalCase(string $string): string
    {
        return \ucwords(\strtolower(\trim($string)));
    }

    public static function fromPascalCaseToCamelCase(string $string): string
    {
        return \lcfirst(\trim($string));
    }
}
