<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\BusinessRule;

final class PrivilegedCodeBusinessRule implements PrivilegedCodeBusinessRuleInterface
{
    public function shouldNotContainABlacklistedWord(
        string $privilegedCode,
    ): bool {
        $privilegedCodePrefix = \substr($privilegedCode, 0, 3);

        foreach (self::BLACKLIST as $blackListedElement) {
            if (\str_contains($privilegedCodePrefix, $blackListedElement)) {
                return false;
            }
        }

        return true;
    }

    public function shouldNotContainTheSameLetterTwiceConsecutively(
        string $privilegedCode,
    ): bool {
        $privilegedCodePrefix = \substr($privilegedCode, 0, 3);
        if (
            $privilegedCodePrefix[1] == $privilegedCodePrefix[0]
            || $privilegedCodePrefix[1] == $privilegedCodePrefix[2]
        ) {
            return false;
        }

        return true;
    }
}
