<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\BusinessRule;

interface DateComparisonBusinessRuleInterface extends BusinessRuleInterface
{
    public function endDateShouldBeTheLastDayOfTheYear(
        \DateTimeInterface $startDate,
        \DateTimeInterface $endDate,
    ): bool;

    public function endDateShouldBeGreaterThanOrEqualsToTheLastDayOfTheYear(
        \DateTimeInterface $startDate,
        \DateTimeInterface $endDate,
    ): bool;

    public function periodShouldNotExceedOneYear(
        \DateTimeInterface $startDate,
        \DateTimeInterface $endDate,
    ): bool;

    /**
     * The $startDate should be lower than $endDate.
     */
    public function shouldBeGreaterThan(
        \DateTimeInterface $startDate,
        \DateTimeInterface $endDate,
    ): bool;

    public function shouldBeGreaterThanNow(
        \DateTimeInterface $date,
    ): bool;
}
