<?php

declare(strict_types=1);

namespace NoahVet\Reef\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * @psalm-suppress PossiblyNullReference, PossiblyUndefinedMethod
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('reef');

        /** @var ArrayNodeDefinition $rootNode */
        $rootNode = $treeBuilder->getRootNode();

        $rootNode
            ->children()
                ->scalarNode('app_name')->isRequired()->end()
                ->scalarNode('url')->isRequired()->end()
                ->scalarNode('oauth_base_url')->defaultNull()->end()
                ->scalarNode('client_id')->isRequired()->end()
                ->scalarNode('client_secret')->isRequired()->end()
                ->scalarNode('service_token')->defaultNull()->end()
                ->scalarNode('cache_service')->defaultNull()->end()
                ->scalarNode('log_url')->defaultValue('syslog://telegraf:6514')->end()
                ->scalarNode('rabbitmq_url')->defaultValue('amqp://rabbitmq/reef')->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
