<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Model\Factory;

use NoahVet\Reef\Business\Model\TeamMember;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse200Item as ManufacturerUsers200Item;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse206Item as ManufacturerUsers206Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200Item as EstablishmentUsers200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse206Item as EstablishmentUsers206Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryGroupUsersGetResponse200Item as GroupUsers200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryGroupUsersGetResponse206Item as GroupUsers206Item;

class TeamMemberFactory
{
    public function create(
        EstablishmentUsers200Item|EstablishmentUsers206Item
        |GroupUsers200Item|GroupUsers206Item
        |ManufacturerUsers200Item|ManufacturerUsers206Item $teamMember,
    ): TeamMember {
        $userId = $teamMember->getUser()?->getId();

        if (null === $userId) {
            throw new \LogicException();
        }

        $entryDate = $teamMember->getEntryDate();
        $exitDate = $teamMember->getExitDate();

        return new TeamMember(
            $userId,
            $teamMember->getJobTitle(),
            $entryDate ? \DateTimeImmutable::createFromMutable($entryDate) : null,
            $exitDate ? \DateTimeImmutable::createFromMutable($exitDate) : null,
        );
    }
}
