<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Model\Factory;

use NoahVet\Reef\Business\Enumerator\ManufacturerTeamMembersEnumerator;
use NoahVet\Reef\Business\Model\ManufacturerWithTeam;
use NoahVet\Reef\Jane\Model\V1ManufacturersGetResponse200Item as Manuf200;
use NoahVet\Reef\Jane\Model\V1ManufacturersGetResponse206Item as Manuf206;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse200Item as ManufUser200;
use NoahVet\Reef\Jane\Model\V1ManufacturerUsersGetResponse206Item as ManufUser206;

class ManufacturerWithTeamFactory
{
    public function __construct(
        protected ManufacturerTeamMembersEnumerator $manufacturerTeamMembersEnumerator,
        protected TeamMemberFactory $teamMemberFactory,
    ) {
    }

    /**
     * @param Manuf200[]|Manuf206[] $manufacturers
     *
     * @return ManufacturerWithTeam[]
     */
    public function createBatch(array $manufacturers): array
    {
        $teamMembers = $this->manufacturerTeamMembersEnumerator->getTeamMembers($manufacturers);

        return \array_map(fn ($m) => $this->build($m, $teamMembers[$m->getId()] ?? []), $manufacturers);
    }

    public function create(Manuf200|Manuf206 $manufacturer): ManufacturerWithTeam
    {
        $teamMembers = $this->manufacturerTeamMembersEnumerator->getTeamMembers([$manufacturer]);

        return $this->build($manufacturer, $teamMembers[$manufacturer->getId()] ?? []);
    }

    /**
     * @param array<ManufUser200|ManufUser206> $teamMembers
     */
    protected function build(
        Manuf200|Manuf206 $manufacturer,
        array $teamMembers,
    ): ManufacturerWithTeam {
        return new ManufacturerWithTeam(
            $manufacturer->getId(),
            $manufacturer->getCode(),
            \array_map(fn ($teamMember) => $this->teamMemberFactory->create($teamMember), $teamMembers),
        );
    }
}
