<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Model\Factory;

use NoahVet\Reef\Business\Enumerator\VeterinaryGroupTeamMembersEnumerator;
use NoahVet\Reef\Business\Model\GroupWithTeam;
use NoahVet\Reef\Business\Model\TeamMember;
use NoahVet\Reef\Jane\Model\V1VeterinaryGroupsGetResponse200Item as Group200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryGroupsGetResponse206Item as Group206Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryGroupsIdGetResponse200 as Group200IdItem;
use NoahVet\Reef\Jane\Model\V1VeterinaryGroupUsersGetResponse200Item as GroupUsers200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryGroupUsersGetResponse206Item as GroupUsers206Item;

class GroupWithTeamFactory
{
    public function __construct(
        protected VeterinaryGroupTeamMembersEnumerator $groupTeamMembersEnumerator,
        protected TeamMemberFactory $teamMemberFactory,
    ) {
    }

    /**
     * @param array<int, Group200Item|Group206Item|Group200IdItem> $groups
     *
     * @return GroupWithTeam[]
     */
    public function createBatch(array $groups): array
    {
        $teamMembers = $this->groupTeamMembersEnumerator->getTeamMembers($groups);

        return \array_map(
            fn (Group200Item|Group206Item|Group200IdItem $est): GroupWithTeam => $this->build(
                $est,
                $teamMembers[$est->getId()] ?? [],
            ),
            $groups,
        );
    }

    public function create(
        Group200Item|Group206Item|Group200IdItem $group,
    ): GroupWithTeam {
        $teamMembers = $this->groupTeamMembersEnumerator->getTeamMembers([$group]);

        return $this->build(
            $group,
            $teamMembers[$group->getId()] ?? [],
        );
    }

    /**
     * @param array<GroupUsers200Item|GroupUsers206Item> $teamMembers
     */
    protected function build(
        Group200Item|Group206Item|Group200IdItem $group,
        array $teamMembers,
    ): GroupWithTeam {
        return new GroupWithTeam(
            $group->getId(),
            $group->getGroupCode() ?? '',
            \array_map(
                fn (GroupUsers200Item|GroupUsers206Item $teamMember): TeamMember => $this->teamMemberFactory->create(
                    $teamMember,
                ),
                $teamMembers,
            ),
        );
    }
}
