<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Model\Factory;

use NoahVet\Reef\Business\Enumerator\VeterinaryEstablishmentTeamMembersEnumerator;
use NoahVet\Reef\Business\Model\EstablishmentWithTeam;
use NoahVet\Reef\Business\Model\TeamMember;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsGetResponse200Item as Estb200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsGetResponse206Item as Estb206Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentsIdGetResponse200 as Estb200IdItem;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse200Item as EstbUsers200Item;
use NoahVet\Reef\Jane\Model\V1VeterinaryEstablishmentUsersGetResponse206Item as EstbUsers206Item;

class EstablishmentWithTeamFactory
{
    public function __construct(
        protected VeterinaryEstablishmentTeamMembersEnumerator $establishmentTeamMembersEnumerator,
        protected TeamMemberFactory $teamMemberFactory,
    ) {
    }

    /**
     * @param array<int, Estb200Item|Estb206Item|Estb200IdItem> $establishments
     *
     * @return EstablishmentWithTeam[]
     */
    public function createBatch(array $establishments): array
    {
        $teamMembers = $this->establishmentTeamMembersEnumerator->getTeamMembers($establishments);

        return \array_map(
            fn (Estb200Item|Estb206Item|Estb200IdItem $est): EstablishmentWithTeam => $this->build(
                $est,
                $teamMembers[$est->getId()] ?? [],
            ),
            $establishments,
        );
    }

    public function create(
        Estb200Item|Estb206Item|Estb200IdItem $establishment,
    ): EstablishmentWithTeam {
        $teamMembers = $this->establishmentTeamMembersEnumerator->getTeamMembers([$establishment]);

        return $this->build(
            $establishment,
            $teamMembers[$establishment->getId()] ?? [],
        );
    }

    /**
     * @param array<EstbUsers200Item|EstbUsers206Item> $teamMembers
     */
    protected function build(
        Estb200Item|Estb206Item|Estb200IdItem $establishment,
        array $teamMembers,
    ): EstablishmentWithTeam {
        return new EstablishmentWithTeam(
            $establishment->getId(),
            $establishment->getPrivilegedCode(),
            \array_map(
                fn (EstbUsers200Item|EstbUsers206Item $teamMember): TeamMember => $this->teamMemberFactory->create(
                    $teamMember,
                ),
                $teamMembers,
            ),
        );
    }
}
