<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Enumerator;

use NoahVet\Reef\Jane\Client;
use NoahVet\Reef\Jane\Exception\GetAllManufacturerBadRequestException;
use NoahVet\Reef\Jane\Model\V1ManufacturersGetResponse200Item as Manuf200;
use NoahVet\Reef\Jane\Model\V1ManufacturersGetResponse206Item as Manuf206;

class ManufacturerEnumerator
{
    public function __construct(
        protected Client $client,
    ) {
    }

    /**
     * @param ?string[] $idFilter
     *
     * @return \Generator<string, Manuf200|Manuf206>
     */
    public function enumerateAll(array $idFilter = null, int $querySize = 50): \Generator
    {
        for ($page = 0; true; ++$page) {
            try {
                $params = ['page' => $page, 'limit' => $querySize];
                if ($idFilter) {
                    $params['id'] = $idFilter;
                }

                $manufacturers = $this->client->getAllManufacturer($params);

                \assert(\is_array($manufacturers));

                foreach ($manufacturers as $manufacturer) {
                    yield $manufacturer->getId() => $manufacturer;
                }

                if (\count($manufacturers) < $querySize) {
                    break;
                }
            } catch (GetAllManufacturerBadRequestException) {
                // End of enumeration
                break;
            }
        }
    }
}
