<?php

namespace NoahVet\PlanningVeto\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\PlanningVeto\Runtime\Normalizer\CheckArray;
use NoahVet\PlanningVeto\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentAddressResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAddressResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAddressResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAddressResponse();
        if (\array_key_exists('lat', $data) && \is_int($data['lat'])) {
            $data['lat'] = (double) $data['lat'];
        }
        if (\array_key_exists('lng', $data) && \is_int($data['lng'])) {
            $data['lng'] = (double) $data['lng'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('updated', $data)) {
            $object->setUpdated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updated']));
            unset($data['updated']);
        }
        if (\array_key_exists('city', $data)) {
            $object->setCity($data['city']);
            unset($data['city']);
        }
        if (\array_key_exists('country', $data)) {
            $object->setCountry($data['country']);
            unset($data['country']);
        }
        if (\array_key_exists('department', $data) && $data['department'] !== null) {
            $object->setDepartment($data['department']);
            unset($data['department']);
        }
        elseif (\array_key_exists('department', $data) && $data['department'] === null) {
            $object->setDepartment(null);
        }
        if (\array_key_exists('postalCode', $data)) {
            $object->setPostalCode($data['postalCode']);
            unset($data['postalCode']);
        }
        if (\array_key_exists('region', $data) && $data['region'] !== null) {
            $object->setRegion($data['region']);
            unset($data['region']);
        }
        elseif (\array_key_exists('region', $data) && $data['region'] === null) {
            $object->setRegion(null);
        }
        if (\array_key_exists('streetName', $data)) {
            $object->setStreetName($data['streetName']);
            unset($data['streetName']);
        }
        if (\array_key_exists('streetNumber', $data) && $data['streetNumber'] !== null) {
            $object->setStreetNumber($data['streetNumber']);
            unset($data['streetNumber']);
        }
        elseif (\array_key_exists('streetNumber', $data) && $data['streetNumber'] === null) {
            $object->setStreetNumber(null);
        }
        if (\array_key_exists('lat', $data)) {
            $object->setLat($data['lat']);
            unset($data['lat']);
        }
        if (\array_key_exists('lng', $data)) {
            $object->setLng($data['lng']);
            unset($data['lng']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['created'] = $data->getCreated()?->format('Y-m-d\\TH:i:sP');
        if ($data->isInitialized('updated') && null !== $data->getUpdated()) {
            $dataArray['updated'] = $data->getUpdated()?->format('Y-m-d\\TH:i:sP');
        }
        $dataArray['city'] = $data->getCity();
        $dataArray['country'] = $data->getCountry();
        $dataArray['department'] = $data->getDepartment();
        $dataArray['postalCode'] = $data->getPostalCode();
        $dataArray['region'] = $data->getRegion();
        $dataArray['streetName'] = $data->getStreetName();
        $dataArray['streetNumber'] = $data->getStreetNumber();
        $dataArray['lat'] = $data->getLat();
        $dataArray['lng'] = $data->getLng();
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAddressResponse::class => false];
    }
}