<?php

namespace NoahVet\PlanningVeto\Normalizer;

use NoahVet\PlanningVeto\Runtime\Normalizer\CheckArray;
use NoahVet\PlanningVeto\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class JaneObjectNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    protected $normalizers = [
        
        \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigResponse::class => \NoahVet\PlanningVeto\Normalizer\VeterinaryEstablishmentConfigResponseNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest::class => \NoahVet\PlanningVeto\Normalizer\VeterinaryEstablishmentConfigRequestNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\ReasonResponse::class => \NoahVet\PlanningVeto\Normalizer\ReasonResponseNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\ReasonResponseVeterinaryEstablishmentConfig::class => \NoahVet\PlanningVeto\Normalizer\ReasonResponseVeterinaryEstablishmentConfigNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\ReasonRequest::class => \NoahVet\PlanningVeto\Normalizer\ReasonRequestNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\ComponentsSchemasReasonResponse::class => \NoahVet\PlanningVeto\Normalizer\ComponentsSchemasReasonResponseNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\ComponentsSchemasReasonResponseVeterinaryEstablishmentConfig::class => \NoahVet\PlanningVeto\Normalizer\ComponentsSchemasReasonResponseVeterinaryEstablishmentConfigNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\ReasonResponseComponentsSchemasReasonResponse::class => \NoahVet\PlanningVeto\Normalizer\ReasonResponseComponentsSchemasReasonResponseNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\ReasonResponseComponentsSchemasReasonResponseVeterinaryEstablishmentConfig::class => \NoahVet\PlanningVeto\Normalizer\ReasonResponseComponentsSchemasReasonResponseVeterinaryEstablishmentConfigNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\SchemasReasonRequest::class => \NoahVet\PlanningVeto\Normalizer\SchemasReasonRequestNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\CaregiverResponse::class => \NoahVet\PlanningVeto\Normalizer\CaregiverResponseNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\CaregiverRequest::class => \NoahVet\PlanningVeto\Normalizer\CaregiverRequestNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventResponse::class => \NoahVet\PlanningVeto\Normalizer\EventResponseNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventResponseCaregiverVeterinaryEstablishment::class => \NoahVet\PlanningVeto\Normalizer\EventResponseCaregiverVeterinaryEstablishmentNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventResponseReason::class => \NoahVet\PlanningVeto\Normalizer\EventResponseReasonNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventResponseCustomer::class => \NoahVet\PlanningVeto\Normalizer\EventResponseCustomerNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventResponseEventType::class => \NoahVet\PlanningVeto\Normalizer\EventResponseEventTypeNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventResponseCaregiver::class => \NoahVet\PlanningVeto\Normalizer\EventResponseCaregiverNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventRequest::class => \NoahVet\PlanningVeto\Normalizer\EventRequestNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventRequestCaregiverVeterinaryEstablishment::class => \NoahVet\PlanningVeto\Normalizer\EventRequestCaregiverVeterinaryEstablishmentNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventRequestReason::class => \NoahVet\PlanningVeto\Normalizer\EventRequestReasonNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventRequestCustomer::class => \NoahVet\PlanningVeto\Normalizer\EventRequestCustomerNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventRequestCaregiver::class => \NoahVet\PlanningVeto\Normalizer\EventRequestCaregiverNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\EventRequestEventType::class => \NoahVet\PlanningVeto\Normalizer\EventRequestEventTypeNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\CaregiverEventRequest::class => \NoahVet\PlanningVeto\Normalizer\CaregiverEventRequestNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchRequest::class => \NoahVet\PlanningVeto\Normalizer\VeterinaryEstablishmentSearchRequestNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAddressResponse::class => \NoahVet\PlanningVeto\Normalizer\VeterinaryEstablishmentAddressResponseNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchResponseItem::class => \NoahVet\PlanningVeto\Normalizer\VeterinaryEstablishmentSearchResponseItemNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\Slot::class => \NoahVet\PlanningVeto\Normalizer\SlotNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\Caregiver::class => \NoahVet\PlanningVeto\Normalizer\CaregiverNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfig::class => \NoahVet\PlanningVeto\Normalizer\VeterinaryEstablishmentConfigNormalizer::class,
        
        \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAvailabilitiesResponse::class => \NoahVet\PlanningVeto\Normalizer\VeterinaryEstablishmentAvailabilitiesResponseNormalizer::class,
        
        \Jane\Component\JsonSchemaRuntime\Reference::class => \NoahVet\PlanningVeto\Runtime\Normalizer\ReferenceNormalizer::class,
    ], $normalizersCache = [];
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return array_key_exists($type, $this->normalizers);
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && array_key_exists(get_class($data), $this->normalizers);
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $normalizerClass = $this->normalizers[get_class($data)];
        $normalizer = $this->getNormalizer($normalizerClass);
        return $normalizer->normalize($data, $format, $context);
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        $denormalizerClass = $this->normalizers[$type];
        $denormalizer = $this->getNormalizer($denormalizerClass);
        return $denormalizer->denormalize($data, $type, $format, $context);
    }
    private function getNormalizer(string $normalizerClass)
    {
        return $this->normalizersCache[$normalizerClass] ?? $this->initNormalizer($normalizerClass);
    }
    private function initNormalizer(string $normalizerClass)
    {
        $normalizer = new $normalizerClass();
        $normalizer->setNormalizer($this->normalizer);
        $normalizer->setDenormalizer($this->denormalizer);
        $this->normalizersCache[$normalizerClass] = $normalizer;
        return $normalizer;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [
            
            \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigResponse::class => false,
            \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest::class => false,
            \NoahVet\PlanningVeto\Model\ReasonResponse::class => false,
            \NoahVet\PlanningVeto\Model\ReasonResponseVeterinaryEstablishmentConfig::class => false,
            \NoahVet\PlanningVeto\Model\ReasonRequest::class => false,
            \NoahVet\PlanningVeto\Model\ComponentsSchemasReasonResponse::class => false,
            \NoahVet\PlanningVeto\Model\ComponentsSchemasReasonResponseVeterinaryEstablishmentConfig::class => false,
            \NoahVet\PlanningVeto\Model\ReasonResponseComponentsSchemasReasonResponse::class => false,
            \NoahVet\PlanningVeto\Model\ReasonResponseComponentsSchemasReasonResponseVeterinaryEstablishmentConfig::class => false,
            \NoahVet\PlanningVeto\Model\SchemasReasonRequest::class => false,
            \NoahVet\PlanningVeto\Model\CaregiverResponse::class => false,
            \NoahVet\PlanningVeto\Model\CaregiverRequest::class => false,
            \NoahVet\PlanningVeto\Model\EventResponse::class => false,
            \NoahVet\PlanningVeto\Model\EventResponseCaregiverVeterinaryEstablishment::class => false,
            \NoahVet\PlanningVeto\Model\EventResponseReason::class => false,
            \NoahVet\PlanningVeto\Model\EventResponseCustomer::class => false,
            \NoahVet\PlanningVeto\Model\EventResponseEventType::class => false,
            \NoahVet\PlanningVeto\Model\EventResponseCaregiver::class => false,
            \NoahVet\PlanningVeto\Model\EventRequest::class => false,
            \NoahVet\PlanningVeto\Model\EventRequestCaregiverVeterinaryEstablishment::class => false,
            \NoahVet\PlanningVeto\Model\EventRequestReason::class => false,
            \NoahVet\PlanningVeto\Model\EventRequestCustomer::class => false,
            \NoahVet\PlanningVeto\Model\EventRequestCaregiver::class => false,
            \NoahVet\PlanningVeto\Model\EventRequestEventType::class => false,
            \NoahVet\PlanningVeto\Model\CaregiverEventRequest::class => false,
            \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchRequest::class => false,
            \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAddressResponse::class => false,
            \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchResponseItem::class => false,
            \NoahVet\PlanningVeto\Model\Slot::class => false,
            \NoahVet\PlanningVeto\Model\Caregiver::class => false,
            \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfig::class => false,
            \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAvailabilitiesResponse::class => false,
            \Jane\Component\JsonSchemaRuntime\Reference::class => false,
        ];
    }
}