<?php

namespace NoahVet\PlanningVeto;

class Client extends \NoahVet\PlanningVeto\Runtime\Client\Client
{
    /**
     * Get a Veterinary Establishment Configuration.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\PlanningVeto\Exception\GetOnePvVeterinaryEstablishmentConfigurationBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\GetOnePvVeterinaryEstablishmentConfigurationNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOnePvVeterinaryEstablishmentConfiguration(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\GetOnePvVeterinaryEstablishmentConfiguration($id, $headerParameters), $fetch);
    }
    /**
     * Update a PlanningVeto Veterinary Establishment Configuration.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOnePvVeterinaryEstablishmentConfigurationBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOnePvVeterinaryEstablishmentConfigurationNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOnePvVeterinaryEstablishmentConfiguration(string $id, \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\UpdateOnePvVeterinaryEstablishmentConfiguration($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List reasons for a veterinary establishment.
    A reason is a subject of appointment defined by veterinary establishment.
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $reasonId[] Filter by reasonId.
    *     @var array $veterinaryEstablishmentConfigId[] Filter by veterinaryEstablishmentId.
    *     @var string $sortCreated Sort by created.
    *     @var string $sortUpdated Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\PlanningVeto\Exception\GetAllEstablishmentReasonsBadRequestException
    * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\PlanningVeto\Model\ReasonResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllEstablishmentReasons(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\GetAllEstablishmentReasons($queryParameters, $headerParameters), $fetch);
    }
    /**
    * Create a reason for a veterinary establishment.
    
    A reason is a subject of appointment defined by veterinary establishment.
    
    *
    * @param \NoahVet\PlanningVeto\Model\ReasonRequest $requestBody 
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\PlanningVeto\Exception\PostVeterinaryEstablishmentReasonBadRequestException
    * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\PlanningVeto\Model\ComponentsSchemasReasonResponse|\Psr\Http\Message\ResponseInterface
    */
    public function postVeterinaryEstablishmentReason(\NoahVet\PlanningVeto\Model\ReasonRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\PostVeterinaryEstablishmentReason($requestBody, $headerParameters), $fetch);
    }
    /**
     * Get a Reason.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\PlanningVeto\Exception\GetOneReasonBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\GetOneReasonNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\ReasonResponseComponentsSchemasReasonResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneReason(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\GetOneReason($id, $headerParameters), $fetch);
    }
    /**
     * Update a reason.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\PlanningVeto\Model\SchemasReasonRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOneReasonBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOneReasonNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\ReasonResponseComponentsSchemasReasonResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneReason(string $id, \NoahVet\PlanningVeto\Model\SchemasReasonRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\UpdateOneReason($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List of caregiver for a veterinary establishment.
    
    *
    * @param string $id The resource ID.
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $eventStatus[] Filter events by status.
    *     @var array $fromEventStartPeriodDateRequest[] Returns event results whose `startDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toEventStartPeriodDateRequest[] Returns event results whose `endDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreated Sort by created.
    *     @var string $sortUpdated Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\PlanningVeto\Exception\GetAllCaregiverBadRequestException
    * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\PlanningVeto\Model\CaregiverResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllCaregiver(string $id, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\GetAllCaregiver($id, $queryParameters, $headerParameters), $fetch);
    }
    /**
     * Update a caregiver
     *
     * @param string $id The resource ID.
     * @param \NoahVet\PlanningVeto\Model\CaregiverRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\PlanningVeto\Exception\UpdateCaregiverBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UpdateCaregiverNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return null|\Psr\Http\Message\ResponseInterface
     */
    public function updateCaregiver(string $id, \NoahVet\PlanningVeto\Model\CaregiverRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\UpdateCaregiver($id, $requestBody, $headerParameters), $fetch);
    }
    /**
    * List of events.
    
    *
    * @param string $id The resource ID.
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $eventStatus[] Filter events by status.
    *     @var array $veterinaryEstablishmentConfigId[] Filter by veterinaryEstablishmentId.
    *     @var array $caregiverId[] Filter by veterinaryEstablishmentId.
    *     @var array $fromEventStartPeriodDateRequest[] Returns event results whose `startDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toEventStartPeriodDateRequest[] Returns event results whose `endDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreated Sort by created.
    *     @var string $sortUpdated Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\PlanningVeto\Exception\GetAllEventBadRequestException
    * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\PlanningVeto\Model\EventResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllEvent(string $id, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\GetAllEvent($id, $queryParameters, $headerParameters), $fetch);
    }
    /**
     * Create an event.
     *
     * @param \NoahVet\PlanningVeto\Model\EventRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\PlanningVeto\Exception\PostEventBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\EventResponse|\Psr\Http\Message\ResponseInterface
     */
    public function postEvent(\NoahVet\PlanningVeto\Model\EventRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\PostEvent($requestBody, $headerParameters), $fetch);
    }
    /**
     * Get one event from caregiver schedule
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\PlanningVeto\Exception\GetOneCaregiverEventBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\GetOneCaregiverEventNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\EventResponse|\Psr\Http\Message\ResponseInterface
     */
    public function getOneCaregiverEvent(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\GetOneCaregiverEvent($id, $headerParameters), $fetch);
    }
    /**
     * Update an event in caregiver schedule
     *
     * @param string $id The resource ID.
     * @param \NoahVet\PlanningVeto\Model\CaregiverEventRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOneCaregiverEventBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOneCaregiverEventNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\EventResponse|\Psr\Http\Message\ResponseInterface
     */
    public function updateOneCaregiverEvent(string $id, \NoahVet\PlanningVeto\Model\CaregiverEventRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\UpdateOneCaregiverEvent($id, $requestBody, $headerParameters), $fetch);
    }
    /**
     * List of establishments to search by text or by coordinates.
     *
     * @param \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchRequest $requestBody 
     * @param array $queryParameters {
     *     @var int $page The page of items to collect a part of result set.
     *     @var int $limit The maximum number of items to collect a part of result set.
     *     @var string $sortCreated Sort by created.
     *     @var string $sortUpdated Sort by updatedDate.
     * }
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     * @throws \NoahVet\PlanningVeto\Exception\GetPvVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchResponseItem[]|\Psr\Http\Message\ResponseInterface
     */
    public function getPvVeterinaryEstablishment(\NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\GetPvVeterinaryEstablishment($requestBody, $queryParameters, $headerParameters), $fetch);
    }
    /**
    * List of available slots returned during an appointment request
    
    *
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $fromAvailabilityDateRequest[] Returns availabilities results whose `startDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toAvailabilityDateRequest[] Returns availabilities results whose `endDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var array $veterinaryEstablishmentConfigId[] Filter by veterinaryEstablishmentId.
    *     @var array $reasonId[] Filter by reasonId.
    *     @var array $principalId[] Filter by principalId.
    *     @var string $sortCreated Sort by created.
    *     @var string $sortUpdated Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
    * @throws \NoahVet\PlanningVeto\Exception\GetAllAvailableSlotBadRequestException
    * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
    *
    * @return \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAvailabilitiesResponse[]|\Psr\Http\Message\ResponseInterface
    */
    public function getAllAvailableSlot(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \NoahVet\PlanningVeto\Endpoint\GetAllAvailableSlot($queryParameters, $headerParameters), $fetch);
    }
    public static function create($httpClient = null, array $additionalPlugins = [], array $additionalNormalizers = [])
    {
        if (null === $httpClient) {
            $httpClient = \Http\Discovery\Psr18ClientDiscovery::find();
            $plugins = [];
            if (count($additionalPlugins) > 0) {
                $plugins = array_merge($plugins, $additionalPlugins);
            }
            $httpClient = new \Http\Client\Common\PluginClient($httpClient, $plugins);
        }
        $requestFactory = \Http\Discovery\Psr17FactoryDiscovery::findRequestFactory();
        $streamFactory = \Http\Discovery\Psr17FactoryDiscovery::findStreamFactory();
        $normalizers = [new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \NoahVet\PlanningVeto\Normalizer\JaneObjectNormalizer()];
        if (count($additionalNormalizers) > 0) {
            $normalizers = array_merge($normalizers, $additionalNormalizers);
        }
        $serializer = new \Symfony\Component\Serializer\Serializer($normalizers, [new \Symfony\Component\Serializer\Encoder\JsonEncoder(new \Symfony\Component\Serializer\Encoder\JsonEncode(), new \Symfony\Component\Serializer\Encoder\JsonDecode(['json_decode_associative' => true]))]);
        return new static($httpClient, $requestFactory, $serializer, $streamFactory);
    }
}