<?php

namespace NoahVet\PlanningVeto\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\PlanningVeto\Runtime\Normalizer\CheckArray;
use NoahVet\PlanningVeto\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentSearchResponseItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchResponseItem::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchResponseItem::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchResponseItem();
        if (\array_key_exists('forceSelectCaregiver', $data) && \is_int($data['forceSelectCaregiver'])) {
            $data['forceSelectCaregiver'] = (bool) $data['forceSelectCaregiver'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('privilegedCode', $data)) {
            $object->setPrivilegedCode($data['privilegedCode']);
            unset($data['privilegedCode']);
        }
        if (\array_key_exists('name', $data) && $data['name'] !== null) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        elseif (\array_key_exists('name', $data) && $data['name'] === null) {
            $object->setName(null);
        }
        if (\array_key_exists('shortAppointmentDescription', $data) && $data['shortAppointmentDescription'] !== null) {
            $object->setShortAppointmentDescription($data['shortAppointmentDescription']);
            unset($data['shortAppointmentDescription']);
        }
        elseif (\array_key_exists('shortAppointmentDescription', $data) && $data['shortAppointmentDescription'] === null) {
            $object->setShortAppointmentDescription(null);
        }
        if (\array_key_exists('forceSelectCaregiver', $data)) {
            $object->setForceSelectCaregiver($data['forceSelectCaregiver']);
            unset($data['forceSelectCaregiver']);
        }
        if (\array_key_exists('minimalDelayTakeAppointment', $data)) {
            $object->setMinimalDelayTakeAppointment($data['minimalDelayTakeAppointment']);
            unset($data['minimalDelayTakeAppointment']);
        }
        if (\array_key_exists('minimalDelayCancelAppointment', $data) && $data['minimalDelayCancelAppointment'] !== null) {
            $object->setMinimalDelayCancelAppointment($data['minimalDelayCancelAppointment']);
            unset($data['minimalDelayCancelAppointment']);
        }
        elseif (\array_key_exists('minimalDelayCancelAppointment', $data) && $data['minimalDelayCancelAppointment'] === null) {
            $object->setMinimalDelayCancelAppointment(null);
        }
        if (\array_key_exists('emailAppointmentConfirmation', $data) && $data['emailAppointmentConfirmation'] !== null) {
            $object->setEmailAppointmentConfirmation($data['emailAppointmentConfirmation']);
            unset($data['emailAppointmentConfirmation']);
        }
        elseif (\array_key_exists('emailAppointmentConfirmation', $data) && $data['emailAppointmentConfirmation'] === null) {
            $object->setEmailAppointmentConfirmation(null);
        }
        if (\array_key_exists('veterinaryEstablishmentAddress', $data)) {
            $object->setVeterinaryEstablishmentAddress($this->denormalizer->denormalize($data['veterinaryEstablishmentAddress'], \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentAddressResponse::class, 'json', $context));
            unset($data['veterinaryEstablishmentAddress']);
        }
        if (\array_key_exists('caregiverFirstName', $data) && $data['caregiverFirstName'] !== null) {
            $object->setCaregiverFirstName($data['caregiverFirstName']);
            unset($data['caregiverFirstName']);
        }
        elseif (\array_key_exists('caregiverFirstName', $data) && $data['caregiverFirstName'] === null) {
            $object->setCaregiverFirstName(null);
        }
        if (\array_key_exists('caregiverLastName', $data) && $data['caregiverLastName'] !== null) {
            $object->setCaregiverLastName($data['caregiverLastName']);
            unset($data['caregiverLastName']);
        }
        elseif (\array_key_exists('caregiverLastName', $data) && $data['caregiverLastName'] === null) {
            $object->setCaregiverLastName(null);
        }
        if (\array_key_exists('status', $data) && $data['status'] !== null) {
            $object->setStatus($data['status']);
            unset($data['status']);
        }
        elseif (\array_key_exists('status', $data) && $data['status'] === null) {
            $object->setStatus(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['privilegedCode'] = $data->getPrivilegedCode();
        $dataArray['name'] = $data->getName();
        if ($data->isInitialized('shortAppointmentDescription') && null !== $data->getShortAppointmentDescription()) {
            $dataArray['shortAppointmentDescription'] = $data->getShortAppointmentDescription();
        }
        $dataArray['forceSelectCaregiver'] = $data->getForceSelectCaregiver();
        $dataArray['minimalDelayTakeAppointment'] = $data->getMinimalDelayTakeAppointment();
        $dataArray['minimalDelayCancelAppointment'] = $data->getMinimalDelayCancelAppointment();
        if ($data->isInitialized('emailAppointmentConfirmation') && null !== $data->getEmailAppointmentConfirmation()) {
            $dataArray['emailAppointmentConfirmation'] = $data->getEmailAppointmentConfirmation();
        }
        if ($data->isInitialized('veterinaryEstablishmentAddress') && null !== $data->getVeterinaryEstablishmentAddress()) {
            $dataArray['veterinaryEstablishmentAddress'] = $this->normalizer->normalize($data->getVeterinaryEstablishmentAddress(), 'json', $context);
        }
        if ($data->isInitialized('caregiverFirstName') && null !== $data->getCaregiverFirstName()) {
            $dataArray['caregiverFirstName'] = $data->getCaregiverFirstName();
        }
        if ($data->isInitialized('caregiverLastName') && null !== $data->getCaregiverLastName()) {
            $dataArray['caregiverLastName'] = $data->getCaregiverLastName();
        }
        if ($data->isInitialized('status') && null !== $data->getStatus()) {
            $dataArray['status'] = $data->getStatus();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchResponseItem::class => false];
    }
}