<?php

namespace NoahVet\PlanningVeto\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\PlanningVeto\Runtime\Normalizer\CheckArray;
use NoahVet\PlanningVeto\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class EventResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\PlanningVeto\Model\EventResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\PlanningVeto\Model\EventResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\PlanningVeto\Model\EventResponse();
        if (\array_key_exists('automaticCaregiverSelection', $data) && \is_int($data['automaticCaregiverSelection'])) {
            $data['automaticCaregiverSelection'] = (bool) $data['automaticCaregiverSelection'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('caregiverVeterinaryEstablishment', $data)) {
            $object->setCaregiverVeterinaryEstablishment($this->denormalizer->denormalize($data['caregiverVeterinaryEstablishment'], \NoahVet\PlanningVeto\Model\EventResponseCaregiverVeterinaryEstablishment::class, 'json', $context));
            unset($data['caregiverVeterinaryEstablishment']);
        }
        if (\array_key_exists('reason', $data)) {
            $object->setReason($this->denormalizer->denormalize($data['reason'], \NoahVet\PlanningVeto\Model\EventResponseReason::class, 'json', $context));
            unset($data['reason']);
        }
        if (\array_key_exists('status', $data)) {
            $object->setStatus($data['status']);
            unset($data['status']);
        }
        if (\array_key_exists('color', $data)) {
            $object->setColor($data['color']);
            unset($data['color']);
        }
        if (\array_key_exists('customer', $data)) {
            $object->setCustomer($this->denormalizer->denormalize($data['customer'], \NoahVet\PlanningVeto\Model\EventResponseCustomer::class, 'json', $context));
            unset($data['customer']);
        }
        if (\array_key_exists('eventType', $data)) {
            $object->setEventType($this->denormalizer->denormalize($data['eventType'], \NoahVet\PlanningVeto\Model\EventResponseEventType::class, 'json', $context));
            unset($data['eventType']);
        }
        if (\array_key_exists('petName', $data)) {
            $object->setPetName($data['petName']);
            unset($data['petName']);
        }
        if (\array_key_exists('breed', $data)) {
            $object->setBreed($data['breed']);
            unset($data['breed']);
        }
        if (\array_key_exists('species', $data)) {
            $object->setSpecies($data['species']);
            unset($data['species']);
        }
        if (\array_key_exists('petId', $data)) {
            $object->setPetId($data['petId']);
            unset($data['petId']);
        }
        if (\array_key_exists('speciesId', $data)) {
            $object->setSpeciesId($data['speciesId']);
            unset($data['speciesId']);
        }
        if (\array_key_exists('breedId', $data)) {
            $object->setBreedId($data['breedId']);
            unset($data['breedId']);
        }
        if (\array_key_exists('creatorId', $data)) {
            $object->setCreatorId($data['creatorId']);
            unset($data['creatorId']);
        }
        if (\array_key_exists('caregiver', $data)) {
            $object->setCaregiver($this->denormalizer->denormalize($data['caregiver'], \NoahVet\PlanningVeto\Model\EventResponseCaregiver::class, 'json', $context));
            unset($data['caregiver']);
        }
        if (\array_key_exists('startDate', $data)) {
            $object->setStartDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['startDate']));
            unset($data['startDate']);
        }
        if (\array_key_exists('endDate', $data)) {
            $object->setEndDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['endDate']));
            unset($data['endDate']);
        }
        if (\array_key_exists('automaticCaregiverSelection', $data)) {
            $object->setAutomaticCaregiverSelection($data['automaticCaregiverSelection']);
            unset($data['automaticCaregiverSelection']);
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('updated', $data)) {
            $object->setUpdated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updated']));
            unset($data['updated']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        if ($data->isInitialized('caregiverVeterinaryEstablishment') && null !== $data->getCaregiverVeterinaryEstablishment()) {
            $dataArray['caregiverVeterinaryEstablishment'] = $this->normalizer->normalize($data->getCaregiverVeterinaryEstablishment(), 'json', $context);
        }
        if ($data->isInitialized('reason') && null !== $data->getReason()) {
            $dataArray['reason'] = $this->normalizer->normalize($data->getReason(), 'json', $context);
        }
        if ($data->isInitialized('status') && null !== $data->getStatus()) {
            $dataArray['status'] = $data->getStatus();
        }
        if ($data->isInitialized('color') && null !== $data->getColor()) {
            $dataArray['color'] = $data->getColor();
        }
        if ($data->isInitialized('customer') && null !== $data->getCustomer()) {
            $dataArray['customer'] = $this->normalizer->normalize($data->getCustomer(), 'json', $context);
        }
        if ($data->isInitialized('eventType') && null !== $data->getEventType()) {
            $dataArray['eventType'] = $this->normalizer->normalize($data->getEventType(), 'json', $context);
        }
        $dataArray['petName'] = $data->getPetName();
        if ($data->isInitialized('breed') && null !== $data->getBreed()) {
            $dataArray['breed'] = $data->getBreed();
        }
        $dataArray['species'] = $data->getSpecies();
        $dataArray['petId'] = $data->getPetId();
        $dataArray['speciesId'] = $data->getSpeciesId();
        if ($data->isInitialized('breedId') && null !== $data->getBreedId()) {
            $dataArray['breedId'] = $data->getBreedId();
        }
        if ($data->isInitialized('creatorId') && null !== $data->getCreatorId()) {
            $dataArray['creatorId'] = $data->getCreatorId();
        }
        if ($data->isInitialized('caregiver') && null !== $data->getCaregiver()) {
            $dataArray['caregiver'] = $this->normalizer->normalize($data->getCaregiver(), 'json', $context);
        }
        if ($data->isInitialized('startDate') && null !== $data->getStartDate()) {
            $dataArray['startDate'] = $data->getStartDate()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('endDate') && null !== $data->getEndDate()) {
            $dataArray['endDate'] = $data->getEndDate()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('automaticCaregiverSelection') && null !== $data->getAutomaticCaregiverSelection()) {
            $dataArray['automaticCaregiverSelection'] = $data->getAutomaticCaregiverSelection();
        }
        if ($data->isInitialized('created') && null !== $data->getCreated()) {
            $dataArray['created'] = $data->getCreated()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('updated') && null !== $data->getUpdated()) {
            $dataArray['updated'] = $data->getUpdated()?->format('Y-m-d\\TH:i:sP');
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\PlanningVeto\Model\EventResponse::class => false];
    }
}