<?php

namespace NoahVet\PlanningVeto\Endpoint;

class GetAllCaregiver extends \NoahVet\PlanningVeto\Runtime\Client\BaseEndpoint implements \NoahVet\PlanningVeto\Runtime\Client\Endpoint
{
    protected $id;
    /**
    * List of caregiver for a veterinary establishment.
    
    *
    * @param string $id The resource ID.
    * @param array $queryParameters {
    *     @var int $page The page of items to collect a part of result set.
    *     @var int $limit The maximum number of items to collect a part of result set.
    *     @var array $eventStatus[] Filter events by status.
    *     @var array $fromEventStartPeriodDateRequest[] Returns event results whose `startDate` is greater than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |----------Filtered---------|----------Returned----------|
    
    *     @var array $toEventStartPeriodDateRequest[] Returns event results whose `endDate` is lower than or equal to the specified value.
    Example for 2022-03-15 value :
    
    |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
    |-----------Returned--------|---------Filtered-----------|
    
    *     @var string $sortCreated Sort by created.
    *     @var string $sortUpdated Sort by updatedDate.
    * }
    * @param array $headerParameters {
    *     @var string $Accept-Language The current locale.
    * }
    */
    public function __construct(string $id, array $queryParameters = [], array $headerParameters = [])
    {
        $this->id = $id;
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\PlanningVeto\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/veterinary_establishment/{id}/caregivers');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getQueryOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'eventStatus', 'fromEventStartPeriodDateRequest', 'toEventStartPeriodDateRequest', 'sortCreated', 'sortUpdated']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('eventStatus', ['array']);
        $optionsResolver->addAllowedTypes('fromEventStartPeriodDateRequest', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toEventStartPeriodDateRequest', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCreated', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdated', ['string']);
        return $optionsResolver;
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\PlanningVeto\Exception\GetAllCaregiverBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\CaregiverResponse[]
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\PlanningVeto\\Model\\CaregiverResponse[]', 'json');
        }
        if (is_null($contentType) === false && (206 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\PlanningVeto\\Model\\CaregiverResponse[]', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\PlanningVeto\Exception\GetAllCaregiverBadRequestException($response);
        }
        throw new \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}