<?php

namespace NoahVet\PlanningVeto\Model;

class VeterinaryEstablishmentConfigRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Short description displayed near the veterinary establishment availabilities
     *
     * @var string
     */
    protected $shortAppointmentDescription;
    /**
     * Force caregiver selection during availability searching
     *
     * @var bool
     */
    protected $forceSelectCaregiver;
    /**
     * Minimal delay to take an appointment (in minutes)
     *
     * @var int
     */
    protected $minimalDelayTakeAppointment;
    /**
     * Minimal delay to cancel an appointment (in minutes)
     *
     * @var int
     */
    protected $minimalDelayCancelAppointment;
    /**
     * Minimal delay to take an appointment
     *
     * @var string
     */
    protected $emailAppointmentConfirmation;
    /**
     * Short description displayed near the veterinary establishment availabilities
     *
     * @return string
     */
    public function getShortAppointmentDescription() : string
    {
        return $this->shortAppointmentDescription;
    }
    /**
     * Short description displayed near the veterinary establishment availabilities
     *
     * @param string $shortAppointmentDescription
     *
     * @return self
     */
    public function setShortAppointmentDescription(string $shortAppointmentDescription) : self
    {
        $this->initialized['shortAppointmentDescription'] = true;
        $this->shortAppointmentDescription = $shortAppointmentDescription;
        return $this;
    }
    /**
     * Force caregiver selection during availability searching
     *
     * @return bool
     */
    public function getForceSelectCaregiver() : bool
    {
        return $this->forceSelectCaregiver;
    }
    /**
     * Force caregiver selection during availability searching
     *
     * @param bool $forceSelectCaregiver
     *
     * @return self
     */
    public function setForceSelectCaregiver(bool $forceSelectCaregiver) : self
    {
        $this->initialized['forceSelectCaregiver'] = true;
        $this->forceSelectCaregiver = $forceSelectCaregiver;
        return $this;
    }
    /**
     * Minimal delay to take an appointment (in minutes)
     *
     * @return int
     */
    public function getMinimalDelayTakeAppointment() : int
    {
        return $this->minimalDelayTakeAppointment;
    }
    /**
     * Minimal delay to take an appointment (in minutes)
     *
     * @param int $minimalDelayTakeAppointment
     *
     * @return self
     */
    public function setMinimalDelayTakeAppointment(int $minimalDelayTakeAppointment) : self
    {
        $this->initialized['minimalDelayTakeAppointment'] = true;
        $this->minimalDelayTakeAppointment = $minimalDelayTakeAppointment;
        return $this;
    }
    /**
     * Minimal delay to cancel an appointment (in minutes)
     *
     * @return int
     */
    public function getMinimalDelayCancelAppointment() : int
    {
        return $this->minimalDelayCancelAppointment;
    }
    /**
     * Minimal delay to cancel an appointment (in minutes)
     *
     * @param int $minimalDelayCancelAppointment
     *
     * @return self
     */
    public function setMinimalDelayCancelAppointment(int $minimalDelayCancelAppointment) : self
    {
        $this->initialized['minimalDelayCancelAppointment'] = true;
        $this->minimalDelayCancelAppointment = $minimalDelayCancelAppointment;
        return $this;
    }
    /**
     * Minimal delay to take an appointment
     *
     * @return string
     */
    public function getEmailAppointmentConfirmation() : string
    {
        return $this->emailAppointmentConfirmation;
    }
    /**
     * Minimal delay to take an appointment
     *
     * @param string $emailAppointmentConfirmation
     *
     * @return self
     */
    public function setEmailAppointmentConfirmation(string $emailAppointmentConfirmation) : self
    {
        $this->initialized['emailAppointmentConfirmation'] = true;
        $this->emailAppointmentConfirmation = $emailAppointmentConfirmation;
        return $this;
    }
}