<?php

namespace NoahVet\PlanningVeto\Model;

class VeterinaryEstablishmentConfigResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Identifier of the Veterinary Establishment (UUID)
     *
     * @var string
     */
    protected $id;
    /**
     * Name of the Veterinary Establishment
     *
     * @var string|null
     */
    protected $name;
    /**
     * Description shown during the availability searching
     *
     * @var string|null
     */
    protected $shortAppointmentDescription;
    /**
     * Allow the customer to chose an appointment period without selecting a caregiver
     *
     * @var bool|null
     */
    protected $forceSelectCaregiver;
    /**
     * Minimal delay allowed to take an appointment (in minutes)
     *
     * @var int
     */
    protected $minimalDelayTakeAppointment;
    /**
     * Minimal delay allowed for appointment cancelling (in minutes)
     *
     * @var int|null
     */
    protected $minimalDelayCancelAppointment;
    /**
     * Email template send when an appointment is validated by the veterinary establishment
     *
     * @var string|null
     */
    protected $emailAppointmentConfirmation;
    /**
     * Identifier of the Veterinary Establishment (UUID)
     *
     * @return string
     */
    public function getId() : string
    {
        return $this->id;
    }
    /**
     * Identifier of the Veterinary Establishment (UUID)
     *
     * @param string $id
     *
     * @return self
     */
    public function setId(string $id) : self
    {
        $this->initialized['id'] = true;
        $this->id = $id;
        return $this;
    }
    /**
     * Name of the Veterinary Establishment
     *
     * @return string|null
     */
    public function getName() : ?string
    {
        return $this->name;
    }
    /**
     * Name of the Veterinary Establishment
     *
     * @param string|null $name
     *
     * @return self
     */
    public function setName(?string $name) : self
    {
        $this->initialized['name'] = true;
        $this->name = $name;
        return $this;
    }
    /**
     * Description shown during the availability searching
     *
     * @return string|null
     */
    public function getShortAppointmentDescription() : ?string
    {
        return $this->shortAppointmentDescription;
    }
    /**
     * Description shown during the availability searching
     *
     * @param string|null $shortAppointmentDescription
     *
     * @return self
     */
    public function setShortAppointmentDescription(?string $shortAppointmentDescription) : self
    {
        $this->initialized['shortAppointmentDescription'] = true;
        $this->shortAppointmentDescription = $shortAppointmentDescription;
        return $this;
    }
    /**
     * Allow the customer to chose an appointment period without selecting a caregiver
     *
     * @return bool|null
     */
    public function getForceSelectCaregiver() : ?bool
    {
        return $this->forceSelectCaregiver;
    }
    /**
     * Allow the customer to chose an appointment period without selecting a caregiver
     *
     * @param bool|null $forceSelectCaregiver
     *
     * @return self
     */
    public function setForceSelectCaregiver(?bool $forceSelectCaregiver) : self
    {
        $this->initialized['forceSelectCaregiver'] = true;
        $this->forceSelectCaregiver = $forceSelectCaregiver;
        return $this;
    }
    /**
     * Minimal delay allowed to take an appointment (in minutes)
     *
     * @return int
     */
    public function getMinimalDelayTakeAppointment() : int
    {
        return $this->minimalDelayTakeAppointment;
    }
    /**
     * Minimal delay allowed to take an appointment (in minutes)
     *
     * @param int $minimalDelayTakeAppointment
     *
     * @return self
     */
    public function setMinimalDelayTakeAppointment(int $minimalDelayTakeAppointment) : self
    {
        $this->initialized['minimalDelayTakeAppointment'] = true;
        $this->minimalDelayTakeAppointment = $minimalDelayTakeAppointment;
        return $this;
    }
    /**
     * Minimal delay allowed for appointment cancelling (in minutes)
     *
     * @return int|null
     */
    public function getMinimalDelayCancelAppointment() : ?int
    {
        return $this->minimalDelayCancelAppointment;
    }
    /**
     * Minimal delay allowed for appointment cancelling (in minutes)
     *
     * @param int|null $minimalDelayCancelAppointment
     *
     * @return self
     */
    public function setMinimalDelayCancelAppointment(?int $minimalDelayCancelAppointment) : self
    {
        $this->initialized['minimalDelayCancelAppointment'] = true;
        $this->minimalDelayCancelAppointment = $minimalDelayCancelAppointment;
        return $this;
    }
    /**
     * Email template send when an appointment is validated by the veterinary establishment
     *
     * @return string|null
     */
    public function getEmailAppointmentConfirmation() : ?string
    {
        return $this->emailAppointmentConfirmation;
    }
    /**
     * Email template send when an appointment is validated by the veterinary establishment
     *
     * @param string|null $emailAppointmentConfirmation
     *
     * @return self
     */
    public function setEmailAppointmentConfirmation(?string $emailAppointmentConfirmation) : self
    {
        $this->initialized['emailAppointmentConfirmation'] = true;
        $this->emailAppointmentConfirmation = $emailAppointmentConfirmation;
        return $this;
    }
}