<?php

namespace NoahVet\PlanningVeto\Model;

class EventResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Identifier of the event (UUID)
     *
     * @var string
     */
    protected $id;
    /**
     * 
     *
     * @var EventResponseCaregiverVeterinaryEstablishment
     */
    protected $caregiverVeterinaryEstablishment;
    /**
     * 
     *
     * @var EventResponseReason
     */
    protected $reason;
    /**
     * State of the event
     *
     * @var string
     */
    protected $status;
    /**
     * Color of the event to show in the schedule
     *
     * @var string
     */
    protected $color;
    /**
     * 
     *
     * @var EventResponseCustomer
     */
    protected $customer;
    /**
     * 
     *
     * @var EventResponseEventType
     */
    protected $eventType;
    /**
     * Name of the pet in Cam
     *
     * @var string
     */
    protected $petName;
    /**
     * breed of the pet in Cam
     *
     * @var string
     */
    protected $breed;
    /**
     * species of the pet in Cam
     *
     * @var string
     */
    protected $species;
    /**
     * Identifier of the pet (UUID)
     *
     * @var string
     */
    protected $petId;
    /**
     * Identifier of the species of the pet (UUID)
     *
     * @var string
     */
    protected $speciesId;
    /**
     * Identifier of the breed of the pet (UUID)
     *
     * @var string
     */
    protected $breedId;
    /**
     * Identifier of the creator of the event (UUID)
     *
     * @var string
     */
    protected $creatorId;
    /**
     * 
     *
     * @var EventResponseCaregiver
     */
    protected $caregiver;
    /**
     * Date of last update of the event
     *
     * @var \DateTime
     */
    protected $startDate;
    /**
     * Date of last update of the event
     *
     * @var \DateTime
     */
    protected $endDate;
    /**
     * Indicates if the caregiver is automatically selected
     *
     * @var bool
     */
    protected $automaticCaregiverSelection;
    /**
     * Date of creation of the event
     *
     * @var \DateTime
     */
    protected $created;
    /**
     * Date of last update of the event
     *
     * @var \DateTime
     */
    protected $updated;
    /**
     * Identifier of the event (UUID)
     *
     * @return string
     */
    public function getId() : string
    {
        return $this->id;
    }
    /**
     * Identifier of the event (UUID)
     *
     * @param string $id
     *
     * @return self
     */
    public function setId(string $id) : self
    {
        $this->initialized['id'] = true;
        $this->id = $id;
        return $this;
    }
    /**
     * 
     *
     * @return EventResponseCaregiverVeterinaryEstablishment
     */
    public function getCaregiverVeterinaryEstablishment() : EventResponseCaregiverVeterinaryEstablishment
    {
        return $this->caregiverVeterinaryEstablishment;
    }
    /**
     * 
     *
     * @param EventResponseCaregiverVeterinaryEstablishment $caregiverVeterinaryEstablishment
     *
     * @return self
     */
    public function setCaregiverVeterinaryEstablishment(EventResponseCaregiverVeterinaryEstablishment $caregiverVeterinaryEstablishment) : self
    {
        $this->initialized['caregiverVeterinaryEstablishment'] = true;
        $this->caregiverVeterinaryEstablishment = $caregiverVeterinaryEstablishment;
        return $this;
    }
    /**
     * 
     *
     * @return EventResponseReason
     */
    public function getReason() : EventResponseReason
    {
        return $this->reason;
    }
    /**
     * 
     *
     * @param EventResponseReason $reason
     *
     * @return self
     */
    public function setReason(EventResponseReason $reason) : self
    {
        $this->initialized['reason'] = true;
        $this->reason = $reason;
        return $this;
    }
    /**
     * State of the event
     *
     * @return string
     */
    public function getStatus() : string
    {
        return $this->status;
    }
    /**
     * State of the event
     *
     * @param string $status
     *
     * @return self
     */
    public function setStatus(string $status) : self
    {
        $this->initialized['status'] = true;
        $this->status = $status;
        return $this;
    }
    /**
     * Color of the event to show in the schedule
     *
     * @return string
     */
    public function getColor() : string
    {
        return $this->color;
    }
    /**
     * Color of the event to show in the schedule
     *
     * @param string $color
     *
     * @return self
     */
    public function setColor(string $color) : self
    {
        $this->initialized['color'] = true;
        $this->color = $color;
        return $this;
    }
    /**
     * 
     *
     * @return EventResponseCustomer
     */
    public function getCustomer() : EventResponseCustomer
    {
        return $this->customer;
    }
    /**
     * 
     *
     * @param EventResponseCustomer $customer
     *
     * @return self
     */
    public function setCustomer(EventResponseCustomer $customer) : self
    {
        $this->initialized['customer'] = true;
        $this->customer = $customer;
        return $this;
    }
    /**
     * 
     *
     * @return EventResponseEventType
     */
    public function getEventType() : EventResponseEventType
    {
        return $this->eventType;
    }
    /**
     * 
     *
     * @param EventResponseEventType $eventType
     *
     * @return self
     */
    public function setEventType(EventResponseEventType $eventType) : self
    {
        $this->initialized['eventType'] = true;
        $this->eventType = $eventType;
        return $this;
    }
    /**
     * Name of the pet in Cam
     *
     * @return string
     */
    public function getPetName() : string
    {
        return $this->petName;
    }
    /**
     * Name of the pet in Cam
     *
     * @param string $petName
     *
     * @return self
     */
    public function setPetName(string $petName) : self
    {
        $this->initialized['petName'] = true;
        $this->petName = $petName;
        return $this;
    }
    /**
     * breed of the pet in Cam
     *
     * @return string
     */
    public function getBreed() : string
    {
        return $this->breed;
    }
    /**
     * breed of the pet in Cam
     *
     * @param string $breed
     *
     * @return self
     */
    public function setBreed(string $breed) : self
    {
        $this->initialized['breed'] = true;
        $this->breed = $breed;
        return $this;
    }
    /**
     * species of the pet in Cam
     *
     * @return string
     */
    public function getSpecies() : string
    {
        return $this->species;
    }
    /**
     * species of the pet in Cam
     *
     * @param string $species
     *
     * @return self
     */
    public function setSpecies(string $species) : self
    {
        $this->initialized['species'] = true;
        $this->species = $species;
        return $this;
    }
    /**
     * Identifier of the pet (UUID)
     *
     * @return string
     */
    public function getPetId() : string
    {
        return $this->petId;
    }
    /**
     * Identifier of the pet (UUID)
     *
     * @param string $petId
     *
     * @return self
     */
    public function setPetId(string $petId) : self
    {
        $this->initialized['petId'] = true;
        $this->petId = $petId;
        return $this;
    }
    /**
     * Identifier of the species of the pet (UUID)
     *
     * @return string
     */
    public function getSpeciesId() : string
    {
        return $this->speciesId;
    }
    /**
     * Identifier of the species of the pet (UUID)
     *
     * @param string $speciesId
     *
     * @return self
     */
    public function setSpeciesId(string $speciesId) : self
    {
        $this->initialized['speciesId'] = true;
        $this->speciesId = $speciesId;
        return $this;
    }
    /**
     * Identifier of the breed of the pet (UUID)
     *
     * @return string
     */
    public function getBreedId() : string
    {
        return $this->breedId;
    }
    /**
     * Identifier of the breed of the pet (UUID)
     *
     * @param string $breedId
     *
     * @return self
     */
    public function setBreedId(string $breedId) : self
    {
        $this->initialized['breedId'] = true;
        $this->breedId = $breedId;
        return $this;
    }
    /**
     * Identifier of the creator of the event (UUID)
     *
     * @return string
     */
    public function getCreatorId() : string
    {
        return $this->creatorId;
    }
    /**
     * Identifier of the creator of the event (UUID)
     *
     * @param string $creatorId
     *
     * @return self
     */
    public function setCreatorId(string $creatorId) : self
    {
        $this->initialized['creatorId'] = true;
        $this->creatorId = $creatorId;
        return $this;
    }
    /**
     * 
     *
     * @return EventResponseCaregiver
     */
    public function getCaregiver() : EventResponseCaregiver
    {
        return $this->caregiver;
    }
    /**
     * 
     *
     * @param EventResponseCaregiver $caregiver
     *
     * @return self
     */
    public function setCaregiver(EventResponseCaregiver $caregiver) : self
    {
        $this->initialized['caregiver'] = true;
        $this->caregiver = $caregiver;
        return $this;
    }
    /**
     * Date of last update of the event
     *
     * @return \DateTime
     */
    public function getStartDate() : \DateTime
    {
        return $this->startDate;
    }
    /**
     * Date of last update of the event
     *
     * @param \DateTime $startDate
     *
     * @return self
     */
    public function setStartDate(\DateTime $startDate) : self
    {
        $this->initialized['startDate'] = true;
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Date of last update of the event
     *
     * @return \DateTime
     */
    public function getEndDate() : \DateTime
    {
        return $this->endDate;
    }
    /**
     * Date of last update of the event
     *
     * @param \DateTime $endDate
     *
     * @return self
     */
    public function setEndDate(\DateTime $endDate) : self
    {
        $this->initialized['endDate'] = true;
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Indicates if the caregiver is automatically selected
     *
     * @return bool
     */
    public function getAutomaticCaregiverSelection() : bool
    {
        return $this->automaticCaregiverSelection;
    }
    /**
     * Indicates if the caregiver is automatically selected
     *
     * @param bool $automaticCaregiverSelection
     *
     * @return self
     */
    public function setAutomaticCaregiverSelection(bool $automaticCaregiverSelection) : self
    {
        $this->initialized['automaticCaregiverSelection'] = true;
        $this->automaticCaregiverSelection = $automaticCaregiverSelection;
        return $this;
    }
    /**
     * Date of creation of the event
     *
     * @return \DateTime
     */
    public function getCreated() : \DateTime
    {
        return $this->created;
    }
    /**
     * Date of creation of the event
     *
     * @param \DateTime $created
     *
     * @return self
     */
    public function setCreated(\DateTime $created) : self
    {
        $this->initialized['created'] = true;
        $this->created = $created;
        return $this;
    }
    /**
     * Date of last update of the event
     *
     * @return \DateTime
     */
    public function getUpdated() : \DateTime
    {
        return $this->updated;
    }
    /**
     * Date of last update of the event
     *
     * @param \DateTime $updated
     *
     * @return self
     */
    public function setUpdated(\DateTime $updated) : self
    {
        $this->initialized['updated'] = true;
        $this->updated = $updated;
        return $this;
    }
}