<?php

namespace NoahVet\PlanningVeto\Endpoint;

class GetOneReason extends \NoahVet\PlanningVeto\Runtime\Client\BaseEndpoint implements \NoahVet\PlanningVeto\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Get a Reason.
     *
     * @param string $id The resource ID.
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, array $headerParameters = [])
    {
        $this->id = $id;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\PlanningVeto\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'GET';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/veterinary_establishment_reason/{id}');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\PlanningVeto\Exception\GetOneReasonBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\GetOneReasonNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\ReasonResponseComponentsSchemasReasonResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\PlanningVeto\\Model\\ReasonResponseComponentsSchemasReasonResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\PlanningVeto\Exception\GetOneReasonBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\PlanningVeto\Exception\GetOneReasonNotFoundException($response);
        }
        throw new \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}