<?php

namespace NoahVet\PlanningVeto\Model;

class VeterinaryEstablishmentSearchRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * 
     *
     * @var float
     */
    protected $lng;
    /**
     * 
     *
     * @var float
     */
    protected $lat;
    /**
     * 
     *
     * @var float
     */
    protected $maxDistance;
    /**
     * Text to search to get veterinary establishments (it could be the name of the establishment, the privileged code or the name of one caregiver of the establishment). It could also be geolocalized coordinates "lng:lat".
     *
     * @var string
     */
    protected $keywords;
    /**
     * 
     *
     * @return float
     */
    public function getLng() : float
    {
        return $this->lng;
    }
    /**
     * 
     *
     * @param float $lng
     *
     * @return self
     */
    public function setLng(float $lng) : self
    {
        $this->initialized['lng'] = true;
        $this->lng = $lng;
        return $this;
    }
    /**
     * 
     *
     * @return float
     */
    public function getLat() : float
    {
        return $this->lat;
    }
    /**
     * 
     *
     * @param float $lat
     *
     * @return self
     */
    public function setLat(float $lat) : self
    {
        $this->initialized['lat'] = true;
        $this->lat = $lat;
        return $this;
    }
    /**
     * 
     *
     * @return float
     */
    public function getMaxDistance() : float
    {
        return $this->maxDistance;
    }
    /**
     * 
     *
     * @param float $maxDistance
     *
     * @return self
     */
    public function setMaxDistance(float $maxDistance) : self
    {
        $this->initialized['maxDistance'] = true;
        $this->maxDistance = $maxDistance;
        return $this;
    }
    /**
     * Text to search to get veterinary establishments (it could be the name of the establishment, the privileged code or the name of one caregiver of the establishment). It could also be geolocalized coordinates "lng:lat".
     *
     * @return string
     */
    public function getKeywords() : string
    {
        return $this->keywords;
    }
    /**
     * Text to search to get veterinary establishments (it could be the name of the establishment, the privileged code or the name of one caregiver of the establishment). It could also be geolocalized coordinates "lng:lat".
     *
     * @param string $keywords
     *
     * @return self
     */
    public function setKeywords(string $keywords) : self
    {
        $this->initialized['keywords'] = true;
        $this->keywords = $keywords;
        return $this;
    }
}