<?php

namespace NoahVet\PlanningVeto\Endpoint;

class UpdateOnePvVeterinaryEstablishmentConfiguration extends \NoahVet\PlanningVeto\Runtime\Client\BaseEndpoint implements \NoahVet\PlanningVeto\Runtime\Client\Endpoint
{
    protected $id;
    /**
     * Update a PlanningVeto Veterinary Establishment Configuration.
     *
     * @param string $id The resource ID.
     * @param \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest $requestBody 
     * @param array $headerParameters {
     *     @var string $Accept-Language The current locale.
     * }
     */
    public function __construct(string $id, \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest $requestBody, array $headerParameters = [])
    {
        $this->id = $id;
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }
    use \NoahVet\PlanningVeto\Runtime\Client\EndpointTrait;
    public function getMethod() : string
    {
        return 'PATCH';
    }
    public function getUri() : string
    {
        return str_replace(['{id}'], [$this->id], '/v1/veterinary_establishment/{id}/admin/config/');
    }
    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null) : array
    {
        if ($this->body instanceof \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }
        return [[], null];
    }
    public function getExtraHeaders() : array
    {
        return ['Accept' => ['application/json']];
    }
    protected function getHeadersOptionsResolver() : \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);
        return $optionsResolver;
    }
    /**
     * {@inheritdoc}
     *
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOnePvVeterinaryEstablishmentConfigurationBadRequestException
     * @throws \NoahVet\PlanningVeto\Exception\UpdateOnePvVeterinaryEstablishmentConfigurationNotFoundException
     * @throws \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException
     *
     * @return \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentConfigResponse
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'NoahVet\\PlanningVeto\\Model\\VeterinaryEstablishmentConfigResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\PlanningVeto\Exception\UpdateOnePvVeterinaryEstablishmentConfigurationBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\PlanningVeto\Exception\UpdateOnePvVeterinaryEstablishmentConfigurationNotFoundException($response);
        }
        throw new \NoahVet\PlanningVeto\Exception\UnexpectedStatusCodeException($status, $body);
    }
    public function getAuthenticationScopes() : array
    {
        return ['BearerAuth'];
    }
}