<?php

namespace NoahVet\PlanningVeto\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\PlanningVeto\Runtime\Normalizer\CheckArray;
use NoahVet\PlanningVeto\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class VeterinaryEstablishmentSearchRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchRequest::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchRequest::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchRequest();
        if (\array_key_exists('lng', $data) && \is_int($data['lng'])) {
            $data['lng'] = (double) $data['lng'];
        }
        if (\array_key_exists('lat', $data) && \is_int($data['lat'])) {
            $data['lat'] = (double) $data['lat'];
        }
        if (\array_key_exists('maxDistance', $data) && \is_int($data['maxDistance'])) {
            $data['maxDistance'] = (double) $data['maxDistance'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('lng', $data)) {
            $object->setLng($data['lng']);
            unset($data['lng']);
        }
        if (\array_key_exists('lat', $data)) {
            $object->setLat($data['lat']);
            unset($data['lat']);
        }
        if (\array_key_exists('maxDistance', $data)) {
            $object->setMaxDistance($data['maxDistance']);
            unset($data['maxDistance']);
        }
        if (\array_key_exists('keywords', $data)) {
            $object->setKeywords($data['keywords']);
            unset($data['keywords']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('lng') && null !== $data->getLng()) {
            $dataArray['lng'] = $data->getLng();
        }
        if ($data->isInitialized('lat') && null !== $data->getLat()) {
            $dataArray['lat'] = $data->getLat();
        }
        if ($data->isInitialized('maxDistance') && null !== $data->getMaxDistance()) {
            $dataArray['maxDistance'] = $data->getMaxDistance();
        }
        if ($data->isInitialized('keywords') && null !== $data->getKeywords()) {
            $dataArray['keywords'] = $data->getKeywords();
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\PlanningVeto\Model\VeterinaryEstablishmentSearchRequest::class => false];
    }
}