<?php

namespace NoahVet\PlanningVeto\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\PlanningVeto\Runtime\Normalizer\CheckArray;
use NoahVet\PlanningVeto\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
class ReasonResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []) : bool
    {
        return $type === \NoahVet\PlanningVeto\Model\ReasonResponse::class;
    }
    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []) : bool
    {
        return is_object($data) && get_class($data) === \NoahVet\PlanningVeto\Model\ReasonResponse::class;
    }
    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []) : mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\PlanningVeto\Model\ReasonResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('veterinaryEstablishmentConfig', $data)) {
            $object->setVeterinaryEstablishmentConfig($this->denormalizer->denormalize($data['veterinaryEstablishmentConfig'], \NoahVet\PlanningVeto\Model\ReasonResponseVeterinaryEstablishmentConfig::class, 'json', $context));
            unset($data['veterinaryEstablishmentConfig']);
        }
        if (\array_key_exists('veterinaryEstablishmentReasonId', $data)) {
            $object->setVeterinaryEstablishmentReasonId($data['veterinaryEstablishmentReasonId']);
            unset($data['veterinaryEstablishmentReasonId']);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('duration', $data)) {
            $object->setDuration($data['duration']);
            unset($data['duration']);
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('updated', $data)) {
            $object->setUpdated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updated']));
            unset($data['updated']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }
        return $object;
    }
    public function normalize(mixed $data, ?string $format = null, array $context = []) : array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        if ($data->isInitialized('veterinaryEstablishmentConfig') && null !== $data->getVeterinaryEstablishmentConfig()) {
            $dataArray['veterinaryEstablishmentConfig'] = $this->normalizer->normalize($data->getVeterinaryEstablishmentConfig(), 'json', $context);
        }
        if ($data->isInitialized('veterinaryEstablishmentReasonId') && null !== $data->getVeterinaryEstablishmentReasonId()) {
            $dataArray['veterinaryEstablishmentReasonId'] = $data->getVeterinaryEstablishmentReasonId();
        }
        if ($data->isInitialized('name') && null !== $data->getName()) {
            $dataArray['name'] = $data->getName();
        }
        if ($data->isInitialized('duration') && null !== $data->getDuration()) {
            $dataArray['duration'] = $data->getDuration();
        }
        if ($data->isInitialized('created') && null !== $data->getCreated()) {
            $dataArray['created'] = $data->getCreated()?->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('updated') && null !== $data->getUpdated()) {
            $dataArray['updated'] = $data->getUpdated()?->format('Y-m-d\\TH:i:sP');
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }
        return $dataArray;
    }
    public function getSupportedTypes(?string $format = null) : array
    {
        return [\NoahVet\PlanningVeto\Model\ReasonResponse::class => false];
    }
}