<?php

namespace NoahVet\PlanningVeto\Model;

class CaregiverResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Identifier of the caregiver (UUID)
     *
     * @var string
     */
    protected $principalId;
    /**
     * 
     *
     * @var list<string>
     */
    protected $caregiverVeterinaryEstablishmentId;
    /**
     * Shortname to be used in the schedule
     *
     * @var string
     */
    protected $shortName;
    /**
     * First name of the caregiver
     *
     * @var string
     */
    protected $firstName;
    /**
     * Last name of the caregiver
     *
     * @var string
     */
    protected $lastName;
    /**
     * Identifier of the customer (UUID)
     *
     * @var string
     */
    protected $color;
    /**
     * Status of the caregiver
     *
     * @var string
     */
    protected $status;
    /**
     * Identifier of the caregiver (UUID)
     *
     * @return string
     */
    public function getPrincipalId() : string
    {
        return $this->principalId;
    }
    /**
     * Identifier of the caregiver (UUID)
     *
     * @param string $principalId
     *
     * @return self
     */
    public function setPrincipalId(string $principalId) : self
    {
        $this->initialized['principalId'] = true;
        $this->principalId = $principalId;
        return $this;
    }
    /**
     * 
     *
     * @return list<string>
     */
    public function getCaregiverVeterinaryEstablishmentId() : array
    {
        return $this->caregiverVeterinaryEstablishmentId;
    }
    /**
     * 
     *
     * @param list<string> $caregiverVeterinaryEstablishmentId
     *
     * @return self
     */
    public function setCaregiverVeterinaryEstablishmentId(array $caregiverVeterinaryEstablishmentId) : self
    {
        $this->initialized['caregiverVeterinaryEstablishmentId'] = true;
        $this->caregiverVeterinaryEstablishmentId = $caregiverVeterinaryEstablishmentId;
        return $this;
    }
    /**
     * Shortname to be used in the schedule
     *
     * @return string
     */
    public function getShortName() : string
    {
        return $this->shortName;
    }
    /**
     * Shortname to be used in the schedule
     *
     * @param string $shortName
     *
     * @return self
     */
    public function setShortName(string $shortName) : self
    {
        $this->initialized['shortName'] = true;
        $this->shortName = $shortName;
        return $this;
    }
    /**
     * First name of the caregiver
     *
     * @return string
     */
    public function getFirstName() : string
    {
        return $this->firstName;
    }
    /**
     * First name of the caregiver
     *
     * @param string $firstName
     *
     * @return self
     */
    public function setFirstName(string $firstName) : self
    {
        $this->initialized['firstName'] = true;
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Last name of the caregiver
     *
     * @return string
     */
    public function getLastName() : string
    {
        return $this->lastName;
    }
    /**
     * Last name of the caregiver
     *
     * @param string $lastName
     *
     * @return self
     */
    public function setLastName(string $lastName) : self
    {
        $this->initialized['lastName'] = true;
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Identifier of the customer (UUID)
     *
     * @return string
     */
    public function getColor() : string
    {
        return $this->color;
    }
    /**
     * Identifier of the customer (UUID)
     *
     * @param string $color
     *
     * @return self
     */
    public function setColor(string $color) : self
    {
        $this->initialized['color'] = true;
        $this->color = $color;
        return $this;
    }
    /**
     * Status of the caregiver
     *
     * @return string
     */
    public function getStatus() : string
    {
        return $this->status;
    }
    /**
     * Status of the caregiver
     *
     * @param string $status
     *
     * @return self
     */
    public function setStatus(string $status) : self
    {
        $this->initialized['status'] = true;
        $this->status = $status;
        return $this;
    }
}