<?php

namespace NoahVet\PlanningVeto\Model;

class ReasonRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * UUID of the veterinary establishment
     *
     * @var string
     */
    protected $veterinaryEstablishmentConfigId;
    /**
     * UUID of the veterinary establishment
     *
     * @var string
     */
    protected $veterinaryEstablishmentReasonId;
    /**
     * 
     *
     * @var string
     */
    protected $name;
    /**
     * 
     *
     * @var int
     */
    protected $duration;
    /**
     * Status of the caregiver
     *
     * @var string
     */
    protected $status;
    /**
     * UUID of the veterinary establishment
     *
     * @return string
     */
    public function getVeterinaryEstablishmentConfigId() : string
    {
        return $this->veterinaryEstablishmentConfigId;
    }
    /**
     * UUID of the veterinary establishment
     *
     * @param string $veterinaryEstablishmentConfigId
     *
     * @return self
     */
    public function setVeterinaryEstablishmentConfigId(string $veterinaryEstablishmentConfigId) : self
    {
        $this->initialized['veterinaryEstablishmentConfigId'] = true;
        $this->veterinaryEstablishmentConfigId = $veterinaryEstablishmentConfigId;
        return $this;
    }
    /**
     * UUID of the veterinary establishment
     *
     * @return string
     */
    public function getVeterinaryEstablishmentReasonId() : string
    {
        return $this->veterinaryEstablishmentReasonId;
    }
    /**
     * UUID of the veterinary establishment
     *
     * @param string $veterinaryEstablishmentReasonId
     *
     * @return self
     */
    public function setVeterinaryEstablishmentReasonId(string $veterinaryEstablishmentReasonId) : self
    {
        $this->initialized['veterinaryEstablishmentReasonId'] = true;
        $this->veterinaryEstablishmentReasonId = $veterinaryEstablishmentReasonId;
        return $this;
    }
    /**
     * 
     *
     * @return string
     */
    public function getName() : string
    {
        return $this->name;
    }
    /**
     * 
     *
     * @param string $name
     *
     * @return self
     */
    public function setName(string $name) : self
    {
        $this->initialized['name'] = true;
        $this->name = $name;
        return $this;
    }
    /**
     * 
     *
     * @return int
     */
    public function getDuration() : int
    {
        return $this->duration;
    }
    /**
     * 
     *
     * @param int $duration
     *
     * @return self
     */
    public function setDuration(int $duration) : self
    {
        $this->initialized['duration'] = true;
        $this->duration = $duration;
        return $this;
    }
    /**
     * Status of the caregiver
     *
     * @return string
     */
    public function getStatus() : string
    {
        return $this->status;
    }
    /**
     * Status of the caregiver
     *
     * @param string $status
     *
     * @return self
     */
    public function setStatus(string $status) : self
    {
        $this->initialized['status'] = true;
        $this->status = $status;
        return $this;
    }
}