<?php

namespace NoahVet\PlanningVeto\Model;

class CaregiverRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * Color of the schedule to show in the schedule
     *
     * @var string
     */
    protected $color;
    /**
     * Short name of the caregiver schedule to show in the schedule grid
     *
     * @var string
     */
    protected $shortName;
    /**
     * State of the caregiver event
     *
     * @var string
     */
    protected $status;
    /**
     * Color of the schedule to show in the schedule
     *
     * @return string
     */
    public function getColor() : string
    {
        return $this->color;
    }
    /**
     * Color of the schedule to show in the schedule
     *
     * @param string $color
     *
     * @return self
     */
    public function setColor(string $color) : self
    {
        $this->initialized['color'] = true;
        $this->color = $color;
        return $this;
    }
    /**
     * Short name of the caregiver schedule to show in the schedule grid
     *
     * @return string
     */
    public function getShortName() : string
    {
        return $this->shortName;
    }
    /**
     * Short name of the caregiver schedule to show in the schedule grid
     *
     * @param string $shortName
     *
     * @return self
     */
    public function setShortName(string $shortName) : self
    {
        $this->initialized['shortName'] = true;
        $this->shortName = $shortName;
        return $this;
    }
    /**
     * State of the caregiver event
     *
     * @return string
     */
    public function getStatus() : string
    {
        return $this->status;
    }
    /**
     * State of the caregiver event
     *
     * @param string $status
     *
     * @return self
     */
    public function setStatus(string $status) : self
    {
        $this->initialized['status'] = true;
        $this->status = $status;
        return $this;
    }
}