<?php

namespace NoahVet\PlanningVeto\Model;

class CaregiverEventRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];
    public function isInitialized($property) : bool
    {
        return array_key_exists($property, $this->initialized);
    }
    /**
     * State of the event
     *
     * @var string
     */
    protected $status;
    /**
     * Date start of the event
     *
     * @var \DateTime
     */
    protected $start;
    /**
     * Date end of the event
     *
     * @var \DateTime
     */
    protected $end;
    /**
     * State of the event
     *
     * @return string
     */
    public function getStatus() : string
    {
        return $this->status;
    }
    /**
     * State of the event
     *
     * @param string $status
     *
     * @return self
     */
    public function setStatus(string $status) : self
    {
        $this->initialized['status'] = true;
        $this->status = $status;
        return $this;
    }
    /**
     * Date start of the event
     *
     * @return \DateTime
     */
    public function getStart() : \DateTime
    {
        return $this->start;
    }
    /**
     * Date start of the event
     *
     * @param \DateTime $start
     *
     * @return self
     */
    public function setStart(\DateTime $start) : self
    {
        $this->initialized['start'] = true;
        $this->start = $start;
        return $this;
    }
    /**
     * Date end of the event
     *
     * @return \DateTime
     */
    public function getEnd() : \DateTime
    {
        return $this->end;
    }
    /**
     * Date end of the event
     *
     * @param \DateTime $end
     *
     * @return self
     */
    public function setEnd(\DateTime $end) : self
    {
        $this->initialized['end'] = true;
        $this->end = $end;
        return $this;
    }
}